<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">



<xsl:variable name="trans" select="document('lang.xml')/translations"/>

<xsl:template name="translate">
<xsl:param name="id"/>
<xsl:text> </xsl:text>
<xsl:variable name="ln">
<xsl:choose>
<xsl:when test="@lang='FR' or ../@lang='FR' or ../../@lang='FR' or ../../../@lang='FR'">FR</xsl:when>
<xsl:when test="@lang='ES' or ../@lang='ES' or ../../@lang='ES' or ../../../@lang='ES'">ES</xsl:when>
<xsl:otherwise>EN</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="t">
<xsl:choose>
<xsl:when test="$ln='EN'"><xsl:value-of select="$trans/entry[@id=$id]/@en"/></xsl:when>
<xsl:when test="$ln='FR'"><xsl:value-of select="$trans/entry[@id=$id]/@fr"/></xsl:when>
<xsl:when test="$ln='ES'"><xsl:value-of select="$trans/entry[@id=$id]/@es"/></xsl:when>
<xsl:otherwise></xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:choose>
<xsl:when test="$t=''">missing translation to <xsl:value-of select="concat($ln,':',$id)"/></xsl:when>
<xsl:otherwise><xsl:value-of select="$t"/></xsl:otherwise>
</xsl:choose>
<xsl:text> </xsl:text>
</xsl:template>


</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c) 2004-2005. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios/><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition></MapperMetaTag>
</metaInformation>
-->