<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
      xmlns:msxsl="urn:schemas-microsoft-com:xslt"


>
	<xsl:param name="skippopup" select="0"/>
    <xsl:include href="flat2html.xsl"/>
    <xsl:include href="amendments.xsl"/>

	<xsl:include href="figs.xsl"/>

	<!-- significant updates -->
    <!--
20031027 TA double language features
20031118 TA guide heading lines + tricks
20040112 TA decisions added
20040114 TA hierarchy-fulltext jump added
20040202 SZM every html tag changed to lower case
20040202 SZM getTimeDifference added
20040312 TA parallel browse for amendments
20040322 TA core-advanced, remarks
20040330 SSZ popup

20050215 actualEdition added
20050215 <i> in 'table' notes references,text was not added
-->
<!--
<msxsl:script language="JScript" implements-prefix="edition"><![CDATA[


  function compute(s)
  {
    s = s.replace("19740701","2");
    s = s.replace("20060101","8");
    s = s.replace("20000101","7");
    s = s.replace("19800101","3");
    s = s.replace("19850101","4");
    s = s.replace("19900101","5");
    s = s.replace("19950101","6");
    s = s.replace("19680901","1");
    return s;
  }

  function recompute(s)
  {

    if( s == "8" ){
	return "20060101";
    }
	return s;
  }


]]>

</msxsl:script>
-->


    <xsl:variable name="targetWindow">xml</xsl:variable>

    <xsl:variable name="otherlevel">
	<xsl:choose>
	<xsl:when test="/ipcEntries/@ipcLevel = 'A' or /ipcEntries/@ipcLevel = 'a'">core</xsl:when>
	<xsl:when test="/ipcEntries/@ipcLevel = 'C' or /ipcEntries/@ipcLevel = 'c'">advanced</xsl:when>
	<xsl:when test="//ipcEntry[@ipcLevel='a' or @ipcLevel='A']">core</xsl:when>
	<xsl:otherwise>advanced</xsl:otherwise>
	</xsl:choose>
    </xsl:variable>

    <xsl:variable name="actualEdition">
        <xsl:choose>
            <xsl:when test="/ipcEntriesList/ipcEntries/@edition"><xsl:value-of select="/ipcEntriesList/ipcEntries/@edition"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="substring(substring-after(/ipcEntries/@displayMode,'e'),1,8)"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

    <xsl:variable name="isquery"><xsl:value-of select="/ipcEntries/@ipcQuery!='' or /ipcEntry/@ipcReference!=''"/></xsl:variable>
    <xsl:variable name="isFulltext"><xsl:value-of select="substring-before(/*/@displayMode,'f')!='' or substring-after(/*/@displayMode,'f')!=''"/></xsl:variable>
    <xsl:output encoding="utf-8"/>
    <xsl:variable name="to">-</xsl:variable>
    <xsl:variable name="displayMode">
		<!-- <xsl:value-of select="edition:compute(string(/ipcEntries/@displayMode))"/> -->
		<xsl:value-of select="@displayMode"/>
	</xsl:variable>
    <xsl:variable name="lc">
		<xsl:text>abcdefghijklmnopqrstuvwxyz</xsl:text>
	</xsl:variable>
    <xsl:variable name="uc">
		<xsl:text>ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:text>
	</xsl:variable>
    <xsl:variable name="isAmendments">
		<xsl:value-of select="substring-before($displayMode,'^')!='' or substring-after($displayMode,'^')!=''"/>
	</xsl:variable>
    <!-- TA20040316
	<xsl:variable name="gh" select="//ipcEntry[@kind='g']"/>
	<xsl:variable name="mgrp" select="//ipcEntry[@kind='m']"/>
	<xsl:variable name="del" select="//ipcEntry[@kind='d']"/>
    -->
    <xsl:template name="symbolcell">
        <xsl:if test="not(@kind='n' or @kind='t' or @kind='g' or @kind='i')">
            <a name="amn{*/@symbol}"/>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="delete or core-advanced or entry-type or renumber or undelete or restore">
                <xsl:call-template name="purgeSymbol"/>
                <xsl:if test="*/@endSymbol and */@endSymbol!='-'">- <xsl:call-template name="purgeEndSymbol"/></xsl:if>
            </xsl:when>
            <xsl:when test="substring-before('#sucm#',*/@kind) != ''">
                <b>
                    <xsl:call-template name="getsymbol"/>
                </b>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="getsymbol"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="delete">
        <xsl:choose>
            <xsl:when test="transferredTo or coveredBy">(<xsl:apply-templates select="transferredTo" mode="delete"/><xsl:apply-templates select="coveredBy" mode="delete"/>
		)</xsl:when>
            <xsl:otherwise>
                <TT>&lt;deleted without transferred to / covered by&gt;</TT>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="deleted">
        <xsl:choose>
            <xsl:when test="transferredTo or coveredBy">(<xsl:apply-templates select="transferredTo" mode="delete"/><xsl:apply-templates select="coveredBy" mode="delete"/>
		)</xsl:when>
            <xsl:otherwise>
                <TT>&lt;deleted without transferred to / covered by&gt;</TT>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="deleteunstructured">
        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id">deleted</xsl:with-param></xsl:call-template>&gt;</TT>
    </xsl:template>
    <xsl:template match="transferredTo">
		<xsl:call-template name="translate"><xsl:with-param name="id" select="'transferred to'"/></xsl:call-template>
        <xsl:text> </xsl:text><xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="coveredBy">
        <xsl:if test="preceding-sibling::transferredTo">,</xsl:if>
		<xsl:call-template name="translate"><xsl:with-param name="id" select="'covered by'"/></xsl:call-template>
        <xsl:text> </xsl:text><xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="transferredTo" mode="delete">
		<xsl:call-template name="translate"><xsl:with-param name="id" select="'transferred to'"/></xsl:call-template>
        <xsl:text> </xsl:text><xsl:apply-templates mode="delete"/>
    </xsl:template>
    <xsl:template match="coveredBy" mode="delete">
        <xsl:if test="preceding-sibling::transferredTo">,</xsl:if>
		<xsl:call-template name="translate"><xsl:with-param name="id" select="'covered by'"/></xsl:call-template>
        <xsl:text> </xsl:text><xsl:apply-templates mode="delete"/>
    </xsl:template>
    <xsl:template name="getsymbol">
        <xsl:choose>
            <xsl:when test="*/@kind='u' or */@kind='s' or */@kind='c' or */@kind='t'"><xsl:call-template name="translate"><xsl:with-param name="id">Title</xsl:with-param></xsl:call-template></xsl:when>
            <xsl:when test="*/@kind='g'"><xsl:call-template name="translate"><xsl:with-param name="id">Guide heading before</xsl:with-param></xsl:call-template><xsl:call-template name="purgeSymbol"/></xsl:when>
            <xsl:when test="*/@kind='n'">
                <xsl:choose>
                    <xsl:when test="string-length(*/@symbol)&gt;4">Note <BR/><xsl:call-template name="purgeSymbol"/><xsl:if test="*/@endSymbol and */@endSymbol != */@symbol and */@endSymbol!='-'">- <xsl:call-template name="purgeEndSymbol"/></xsl:if></xsl:when>
                    <xsl:otherwise><xsl:call-template name="translate"><xsl:with-param name="id">Note after title</xsl:with-param></xsl:call-template></xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="*/@kind='i'">
                <xsl:choose>
			<xsl:when test="string-length(*/@symbol)=4"><xsl:call-template name="translate"><xsl:with-param name="id">Subclass index</xsl:with-param></xsl:call-template></xsl:when>
			<xsl:when test="string-length(*/@symbol)=3"><xsl:call-template name="translate"><xsl:with-param name="id">Class index</xsl:with-param></xsl:call-template></xsl:when>
                    <xsl:otherwise><xsl:value-of select="string-length(*/@symbol)" />Subclass index</xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="4&gt;=string-length(*/@symbol)">Title</xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="purgeSymbol"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="purgeFullSymbol">
        <xsl:variable name="symbol" select="*/@symbol"/>
        <xsl:variable name="st">
			<xsl:choose>
				<xsl:when test="*/@entryType='i'">:</xsl:when>
				<xsl:otherwise>/</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <xsl:choose>
			<xsl:when test="string-length($symbol)=4">
				<xsl:value-of select="$symbol"/>
			</xsl:when>
            <xsl:when test="substring($symbol,5,2)='00'">
                <xsl:value-of select="concat(substring($symbol,1,4),' ',substring($symbol,7,1),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:when test="substring($symbol,5,1)='0'">
                <xsl:value-of select="concat(substring($symbol,1,4),' ',substring($symbol,6,2),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($symbol,1,4),' ',substring($symbol,5,3),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template name="purgeSymbol">
        <xsl:variable name="symbol" select="*/@symbol"/>
        <xsl:variable name="st">
			<xsl:choose>
				<xsl:when test="*/@entryType='i'">:</xsl:when>
				<xsl:otherwise>/</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <xsl:choose>
            <xsl:when test="substring($symbol,5,2)='00'">
                <xsl:value-of select="concat(substring($symbol,7,1),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:when test="substring($symbol,5,1)='0'">
                <xsl:value-of select="concat(substring($symbol,6,2),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($symbol,5,3),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="purgeFullEndSymbol">
        <xsl:variable name="symbol" select="*/@endSymbol"/>
        <xsl:variable name="st">
			<xsl:choose>
				<xsl:when test="*/@entryType='i'">:</xsl:when>
				<xsl:otherwise>/</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <xsl:choose>
			<xsl:when test="string-length($symbol)=4">
				<xsl:value-of select="$symbol"/>
			</xsl:when>
            <xsl:when test="substring($symbol,5,2)='00'">
                <xsl:value-of select="concat(substring($symbol,1,4), ' ', substring($symbol,7,1),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:when test="substring($symbol,5,1)='0'">
                <xsl:value-of select="concat(substring($symbol,1,4), ' ', substring($symbol,6,2),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($symbol,1,4), ' ', substring($symbol,5,3),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="purgeEndSymbol">
        <xsl:variable name="symbol" select="*/@endSymbol"/>
        <xsl:variable name="st">
			<xsl:choose>
				<xsl:when test="*/@entryType='i'">:</xsl:when>
				<xsl:otherwise>/</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <xsl:choose>
            <xsl:when test="substring($symbol,5,2)='00'">
                <xsl:value-of select="concat(substring($symbol,7,1),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:when test="substring($symbol,5,1)='0'">
                <xsl:value-of select="concat(substring($symbol,6,2),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($symbol,5,3),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="purgeSymbolTo">
        <xsl:variable name="symbol" select="*/@toSymbol"/>
        <xsl:variable name="st">
			<xsl:choose>
				<xsl:when test="*/@entryType='i'">:</xsl:when>
				<xsl:otherwise>/</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <xsl:choose>
	    <xsl:when test="4 >= string-length($symbol)">
		<xsl:value-of select="$symbol"/>
	    </xsl:when>
            <xsl:when test="substring($symbol,5,2)='00'">
                <xsl:value-of select="concat(substring($symbol,7,1),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:when test="substring($symbol,5,1)='0'">
                <xsl:value-of select="concat(substring($symbol,6,2),'/',substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($symbol,5,3),'/',substring($symbol,8,string-length($symbol)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="purgeSymbolEndTo">
        <xsl:variable name="symbol" select="*/@endToSymbol"/>
        <xsl:variable name="st">
			<xsl:choose>
				<xsl:when test="*/@entryType='i'">:</xsl:when>
				<xsl:otherwise>/</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
        <xsl:choose>
            <xsl:when test="substring($symbol,5,2)='00'">
                <xsl:value-of select="concat(substring($symbol,7,1),$st,substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:when test="substring($symbol,5,1)='0'">
                <xsl:value-of select="concat(substring($symbol,6,2),'/',substring($symbol,8,string-length($symbol)))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($symbol,5,3),'/',substring($symbol,8,string-length($symbol)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="ipcEntries|staticIpc">
        <html>
            <title>XML IPC/CIB:  <xsl:value-of select="ipcEntry/@symbol"/></title>
            <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
			<script language="javascript" src="{$commonjsname}"></script>
			<script language="javascript" src="{$webservicejsname}"></script>
            <script language="Javascript" src="{$popupjsname}"></script>
            <script language="Javascript" src="{$ripcisjsname}"></script>
            <body onload="javascript:ipcPositionSet();javascript:setResultWindow(); popupReinit()">
                <div id="overDiv" style="z-index: 1000; visibility: hidden; position: absolute; width: 96">
                </div>
				<div onmouseover="javascript:showIPCImageDiv('');" onmouseout="javascript:hideIPCImageDiv();" id="idImgDiv" style="visibility: hidden; position: absolute; width: 142px; height: 54px; z-index: 1;">
				</div>
								<xsl:variable name="source" select="ipcEntry/@source"/>
								<xsl:if test="$source!=''">
									<table width="100%" class="source">
											<tr>
											<td width="50%" class="source-left">
                        Edition: <xsl:value-of select="$actualEdition"/>,
												<xsl:variable name="symbol">
												<xsl:choose>
                        <xsl:when test="string-length(ipcEntry[2]/@symbol) = 1"></xsl:when>
                        <xsl:when test="count(ipcEntry[1]/ipcEntry) > 1"><xsl:value-of  select="./ipcEntry[1]/@symbol"/></xsl:when>
												<xsl:when test="count(ipcEntry[2]/ipcEntry) > 1"><xsl:value-of select="./ipcEntry[2]/@symbol"/></xsl:when>
												<xsl:when test="count(ipcEntry[3]/ipcEntry) > 1"><xsl:value-of select="./ipcEntry[3]/@symbol"/></xsl:when>
												<xsl:otherwise><xsl:value-of select="./ipcEntry[3]/@symbol"/></xsl:otherwise>
												</xsl:choose>
												</xsl:variable>
												<xsl:variable name="lang" select="./ipcEntry/@lang"/>
												<xsl:choose>
                        <xsl:when test="$lang='FR'">
													<xsl:choose>
													<xsl:when test="string-length($symbol)=1">Section</xsl:when>
													<xsl:when test="string-length($symbol)=3">Classe</xsl:when>
													<xsl:when test="string-length($symbol)=4">Sous-classe</xsl:when>
                          <xsl:when test="string-length($symbol)=0">Indexe</xsl:when>
													<xsl:otherwise></xsl:otherwise>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
													<xsl:when test="string-length($symbol)=1">Section</xsl:when>
													<xsl:when test="string-length($symbol)=3">Class</xsl:when>
													<xsl:when test="string-length($symbol)=4">Subclass</xsl:when>
                          <xsl:when test="string-length($symbol)=0">Index</xsl:when>
													<xsl:otherwise></xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
												</xsl:choose>
												<xsl:text> </xsl:text><xsl:value-of select="$symbol"/>
											</td>
											<td width="50%" class="source-right">
												Source: <xsl:value-of select="$source"/>
											</td>
											</tr>
									</table>
								</xsl:if>
                <xsl:choose>
                    <xsl:when test="$displayMode='compiled'">
                        <table width="100%" border="0">
                            <xsl:apply-templates select="ipcEntry" mode="compilation"/>
                        </table>
                    </xsl:when>
                    <xsl:when test="ipcEntry">
                        <xsl:apply-templates select="ipcEntry" mode="inner"/>
                    </xsl:when>
                    <xsl:when test="ipcVersions">
                        <xsl:apply-templates select="ipcVersions/ipcEntry" mode="double"/>
                    </xsl:when>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- TA20040316
	<xsl:template name="ghline">
		<xsl:variable name="symbol" select="@symbol"/>
		<xsl:variable name="subc" select="substring(@symbol,1,4)"/>
		<xsl:variable name="pmgrp" select="$mgrp[substring(@symbol,1,4)=$subc and substring($symbol,5) &gt; substring(@symbol,5)][last()]/@symbol"/>
		<xsl:variable name="lastEndSymbol" select="($gh[substring(@endSymbol,1,4) = $subc])[last()]/@endSymbol"/>
		<xsl:if test="$gh[@endSymbol = $pmgrp] and (not($gh[@symbol = $pmgrp]) or $gh[@symbol=$pmgrp and @endSymbol=$pmgrp]) and not($gh[@symbol=$symbol])">
			<hr/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="ghlined">
		<xsl:variable name="symbol" select="@symbol"/>
		<xsl:variable name="subc" select="substring(@symbol,1,4)"/>
		<xsl:variable name="lastEndSymbol" select="($gh[substring(@endSymbol,1,4) = $subc and substring($symbol,5) &gt;= substring(@endSymbol,5)])[last()]/@endSymbol"/>
		<xsl:choose>
			<xsl:when test="concat('',$lastEndSymbol)='' or substring($lastEndSymbol,5) &gt; substring($symbol,5) or ( $del[substring(@symbol,1,4)=$subc and substring($symbol,5) &gt; substring(@symbol,5) and substring(@symbol,5) &gt; substring($lastEndSymbol,5)])">
			</xsl:when>
			<xsl:otherwise>
				<hr/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
-->
    <xsl:template match="ipcEntry" mode="compilation">
        <xsl:if test="substring(@symbol,1,4) != substring(preceding-sibling::ipcEntry[1]/@symbol,1,4)">
            <tr>
                <td colspan="3" class="subc">Subclass <xsl:value-of select="substring(@symbol,1,4)"/></td>
            </tr>
        </xsl:if>
        <TR>
            <td width="80px"><xsl:call-template name="compilationModifType"/></td>
            <td width="60px"><xsl:call-template name="compilationGetSymbol"/></td>
            <xsl:choose>
                <xsl:when test="flatNotes">
                    <td colspan="2"><xsl:apply-templates select="flatNotes"/></td>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="kind">
					<xsl:choose>
						<xsl:when test="'9' &gt;= @kind and @kind &gt;= '1'">d</xsl:when>
						<xsl:when test="'d' = @kind and 5 &gt; string-length(@symbol)">u</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="@kind"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
                    <xsl:variable name="style">
					<xsl:choose>
						<xsl:when test="@ipcLevel='c' or @ipcLevel='C'" >
							<xsl:value-of select="$kind"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($kind,'-a')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
                    <td>
					<table width="100%" cellpadding="0" cellspacing="0" border="0">
						<tr>
							<xsl:call-template name="dots">
								<xsl:with-param name="kind" select="@kind"/>
								<xsl:with-param name="style" select="$style"/>
							</xsl:call-template>
							<td align="left" width="100%" class="{$style}">
                <xsl:if test="@kind = 'l'"><hr/></xsl:if>
                <xsl:apply-templates select="textBody"/>
								<xsl:if test="@kind != 'n' and @kind != 'i' and @edition">
									<span class="e">
										<xsl:call-template name="nbsp"/>
<!-- 20060625 TA -->
										<xsl:call-template name="nbsp"/>[<xsl:call-template name="getEdition"/>]</span>
								</xsl:if>
							</td>
						</tr>
					</table>
				</td>
                </xsl:otherwise>
            </xsl:choose>
        </TR>
        <!-- <xsl:apply-templates select="amendment"/> -->
    </xsl:template>
    <xsl:template match="ipcEntry" mode="inner">
        <xsl:apply-templates select="flatNotes"/>
          <xsl:variable name="kind">
					<xsl:choose>
						<xsl:when test="'9' &gt;= @kind and @kind &gt;= '1'">d</xsl:when>
						<xsl:when test="'d' = @kind and 5 &gt; string-length(@symbol)">u</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="@kind"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
                <xsl:variable name="style">
					<xsl:choose>
						<xsl:when test="contains($displayMode,'6') or (contains($displayMode,'7') and not(contains($displayMode,'v'))) or @ipcLevel='c' or  @ipcLevel='C'">
							<xsl:value-of select="$kind"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="concat($kind,'-a')"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
        <!-- TA 20040316
		<xsl:if test="@kind='m'">
			<xsl:call-template name="ghline"/>
		</xsl:if>
		<xsl:if test="@kind='d' and substring(@symbol,8,2)='00'">
			<xsl:call-template name="ghlined"/>
		</xsl:if>
    -->
        <xsl:if test="@kind='u' and preceding-sibling::ipcEntry[1]/@kind != 'c' and  preceding-sibling::ipcEntry[1]/@kind != 'n' ">
            <hr/>
        </xsl:if>
        <table width="100%"  cellpadding="0" cellspacing="0" >
		<!-- 20050309 TA disturbing white stripe: in case of advanced notes -->
	    <xsl:if test="@kind='n'">
                <xsl:attribute name="style">padding-top:6pt;padding-bottom:10pt;<xsl:if test="@ipcLevel='a' or @ipcLevel='A'">background-color:#ffffbb</xsl:if></xsl:attribute>
	    </xsl:if>

            <tr class="{$style}">
                <td width="40px" style="vertical-align:middle" class="i{$style}">
				<xsl:if test="@priorityOrder!=''"><SPAN class="prio">P:<xsl:value-of select="@priorityOrder"/></SPAN></xsl:if>
					<xsl:choose>
						<xsl:when test="@symbol=/ipcEntries/@ipcSymbol and @kind != 'i' and @kind != 'n' and @kind != 'g' and @kind != 't' and @kind != 'l'">
							<img src="{concat($admingiffolder,'this.gif')}"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="{concat($admingiffolder,'notthis.gif')}"/>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
					<xsl:when test="ipcVersions">
					</xsl:when>
					<xsl:when test="@acceptanceLevel!='O' or @ofSession!='' or @ofProject!=''">
						<P class="revisionInfo">
							<xsl:value-of select="@acceptanceLevel"/><xsl:text> </xsl:text>
							<xsl:value-of select="@ofSession"/><xsl:text> </xsl:text>
							<xsl:value-of select="@ofProject"/><xsl:text> </xsl:text>
						</P>
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
					</xsl:choose>
				</td>

                <td width="1px">
					<xsl:choose>
						<xsl:when test="@entryType = 'd'">
							<xsl:attribute name="class">lb</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">i<xsl:value-of select="$style"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:call-template name="nbsp"/>
				</td>
                <xsl:call-template name="id">
                    <xsl:with-param name="kind" select="@kind"/>
                    <xsl:with-param name="style" select="$style"/>
                    <xsl:with-param name="kindstyle" select="$kind"/>
                </xsl:call-template>
                <xsl:if test="not(preceding-sibling::ipcEntry)">
                    <xsl:variable name="targetMode">
		              <xsl:choose>
		              <xsl:when test="$isFulltext='false'">f</xsl:when>
		              <xsl:otherwise>h</xsl:otherwise>
		              </xsl:choose>
		            </xsl:variable>
                    <input type="hidden" id="jumpModeDisplayMode" value="{$displayMode}"/>
                    <input type="hidden" id="jumpModeTargetMode" value="{$targetMode}"/>
                    <input type="hidden" id="jumpModeSymbol" value="{@symbol}"/>
                </xsl:if>
<!--				[<xsl:value-of select="count(textBody/*)"/>]-->
				<xsl:choose>
					<xsl:when test="count(textBody/*) = 0">
						<td class="{$style}">
							<xsl:call-template name="nbsp"/>
						</td>
					</xsl:when>
					<xsl:otherwise>
		                <td>
							<table width="100%" cellpadding="0" cellspacing="0" border="0" class="{@kind}">
								<tr>
								<!-- 20050307 TA illegal position
		              			<xsl:if test="@kind = 'l'"><hr/></xsl:if>
								-->
									<xsl:call-template name="dots">
										<xsl:with-param name="kind" select="@kind"/>
										<xsl:with-param name="style" select="$style"/>
									</xsl:call-template>
									<td align="left" width="100%" class="{$style}">
									<!-- 20050307 TA legal position -->
		              					<xsl:if test="@kind = 'l'"><hr/></xsl:if>

									    <xsl:if test="@isDead='Y'">
								                <xsl:attribute name="style">background-image:url(<xsl:value-of select="concat($admingiffolder,'dead.gif')"/>)</xsl:attribute>
									    </xsl:if>
										<xsl:apply-templates select="textBody"/>
										<xsl:if test="@kind != 'n' and @kind != 'i' and @edition">
											<span class="e">
												<xsl:call-template name="nbsp"/>
		<!-- 20060625 TA -->
												<xsl:call-template name="nbsp"/>[<xsl:call-template name="getEdition"/>]</span>
										</xsl:if>
									</td>
								</tr>
							</table>
		          <!-- <xsl:if test="@remark"><P class="remark"><xsl:value-of select="@remark"/></P></xsl:if> -->
						</td>
				  	</xsl:otherwise>
				</xsl:choose>
		<xsl:if test="$isDouble='1'">
			<td width="60px" class="i{$style}">
				<xsl:call-template name="langjump">
				<xsl:with-param name="languages"><xsl:choose><xsl:when test="/*/@languages"><xsl:value-of select="/*/@languages"/></xsl:when><xsl:otherwise>,en,fr,</xsl:otherwise></xsl:choose></xsl:with-param>
				</xsl:call-template>

			      <xsl:if test="@ipcLevel='c' or @ipcLevel='C'">
					<A href="javascript:jumpLevel('{$otherlevel}','{@symbol}','{@endSymbol}')"><img border="0" src="{concat($admingiffolder,$otherlevel,'.gif')}"/></A>
			      </xsl:if>
			</td>
		</xsl:if>
            </tr>
        </table>
        <xsl:if test="$isAmendments != 'false' and amendment">
            <table width="100%">
                <tr>
                    <td width="10%">
						<xsl:call-template name="nbsp"/>
					</td>
                    <td>
				<xsl:for-each select="amendment">
						<table class="amendment">
							<xsl:apply-templates select="." mode="withintext"/>
						</table>
				</xsl:for-each>
					</td>
                </tr>
            </table>
        </xsl:if>
        <xsl:if test="$isquery='true'">
            <hr/>
        </xsl:if>
        <xsl:apply-templates select="illustrations" />
        <xsl:apply-templates select="ipcEntry" mode="inner"/>
    </xsl:template>
    <xsl:template match="amendment" mode="compilation">
        <xsl:variable name="prev" select="../preceding-sibling::ipcEntry[1]/amendment"/>
        <xsl:if test="$prev/@sessionDecided != @sessionDecided or $prev/@project != @project or substring($prev/*/@symbol,1,4) != substring(*/@symbol,1,4)">
            <tr>
                <td colspan="3">
					<hr/>
				</td>
            </tr>
            <tr>
                <td width="5%">
					<xsl:call-template name="nbsp"/>
				</td>
                <td class="subc">
					<xsl:value-of select="substring(*/@symbol,1,4)"/>
				</td>
                <td class="session" colspan="10">Project: <xsl:value-of select="@project"/>, Session: <xsl:value-of select="@sessionDecided"/></td>
            </tr>
        </xsl:if>
        <xsl:call-template name="amendment"/>
    </xsl:template>
    <xsl:template match="amendment" mode="withintext">
        <xsl:variable name="prev" select="../preceding-sibling::ipcEntry[1]/amendment"/>
        <xsl:if test="$prev/@sessionDecided != @sessionDecided or $prev/@project != @project or substring($prev/*/@symbol,1,4) != substring(*/@symbol,1,4)">
            <tr>
                <td colspan="3">
					<hr/>
				</td>
            </tr>
            <tr>
                <td width="5%">
					<xsl:call-template name="nbsp"/>
				</td>
                <td class="subc" width="15%">
					<xsl:value-of select="substring(*/@symbol,1,4)"/>
				</td>
                <td class="session" width="80%">Project: <xsl:value-of select="@project"/>, Session: <xsl:value-of select="@sessionDecided"/></td>
            </tr>
        </xsl:if>
	<tr><td colspan="3">
        <xsl:call-template name="amendment"/>
	</td></tr>
    </xsl:template>
    <xsl:template match="ipcEntry" mode="double">
        <xsl:choose>
            <xsl:when test="@version='2' and ../ipcEntry[@version='1']">
            </xsl:when>
            <xsl:otherwise>
                <!-- TA20040316
				<xsl:if test="@kind='m'">
					<xsl:call-template name="ghline"/>
				</xsl:if>
				<xsl:if test="@kind='d' and substring(@symbol,8,2)='00'">
					<xsl:call-template name="ghlined"/>
				</xsl:if>
        -->
                <xsl:if test="@kind = 'n'">
				<xsl:variable name="noteText"><xsl:call-template name="translate"><xsl:with-param name="id">Note(s)</xsl:with-param></xsl:call-template></xsl:variable>
			<xsl:choose>
			<xsl:when test="../@edition='new' or substring-before(../@edition,'c-mod')!='' or substring-before(../@edition,$actualEdition)!='' or ../@edition=$actualEdition">
				<i><p style="padding-top:10pt"><xsl:value-of select="$noteText"/></p></i>
			</xsl:when>
			<xsl:otherwise>
				<p style="padding-top:10pt"><xsl:value-of select="$noteText"/></p>
			</xsl:otherwise>
			</xsl:choose>
                </xsl:if>
	<xsl:variable name="pk" select="concat(preceding-sibling::ipcEntry[1]/@kind,'')"/>
        <xsl:if test="@kind='u' and $pk != 'c' and $pk != 'n' ">
            <hr/>
        </xsl:if>
                <table width="100%" cellpadding="0" cellspacing="0"  >
		    <xsl:choose>
		    <xsl:when test="@kind='n' and @isDead='Y'">
	                <xsl:attribute name="style">padding-bottom:10pt;background-color:lightgray</xsl:attribute>
		    </xsl:when>
		    <xsl:when test="@kind='n'">
	                <xsl:attribute name="style">padding-bottom:10pt</xsl:attribute>
		    </xsl:when>
		    <xsl:when test="@isDead='Y'">
	                <xsl:attribute name="style">background-color:lightgray</xsl:attribute>
		    </xsl:when>
		    <xsl:otherwise></xsl:otherwise>
		    </xsl:choose>
                    <tr>
                        <td width="8px" style="vertical-align:middle">
							<xsl:choose>
								<xsl:when test="@symbol=/ipcEntries/@ipcSymbol and @kind != 'i' and @kind != 'n' and @kind != 'g' and @kind != 't'">
									<img src="{concat($admingiffolder,'this.gif')}"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="{concat($admingiffolder,'notthis.gif')}"/>
								</xsl:otherwise>
							</xsl:choose>
						</td>
                        <td width="1px">
							<xsl:choose>
								<xsl:when test="@entryType = 'd'">
									<xsl:attribute name="class">lb</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="class">nb</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:call-template name="nbsp"/>
						</td>
                        <xsl:variable name="kind">
							<xsl:choose>
								<xsl:when test="'9' &gt;= @kind and @kind &gt;= '1'">d</xsl:when>
								<xsl:when test="'d' = @kind and 5 &gt; string-length(@symbol)">u</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@kind"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
                        <xsl:variable name="style">
							<xsl:choose>
								<xsl:when test="@ipcLevel='c'  or @ipcLevel='C'">
									<xsl:value-of select="$kind"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="concat($kind,'-a')"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
                        <xsl:call-template name="id">
                            <xsl:with-param name="kind" select="@kind"/>
                            <xsl:with-param name="style" select="$style"/>
                            <xsl:with-param name="kindstyle" select="$kind"/>
                        </xsl:call-template>
                        <td>
							<table width="100%" cellpadding="0" cellspacing="0" border="0"  class="{@kind}">
								<tr>
									<xsl:call-template name="dots">
										<xsl:with-param name="kind" select="@kind"/>
										<xsl:with-param name="style" select="$style"/>
									</xsl:call-template>
									<xsl:choose>
										<xsl:when test="@version='1'">
											<xsl:call-template name="ipcentry-col-1">
												<xsl:with-param name="style" select="$style"/>
											</xsl:call-template>
										</xsl:when>
										<xsl:when test="@version='2'">
											<xsl:call-template name="ipcentry-col-2">
												<xsl:with-param name="style" select="$style"/>
											</xsl:call-template>
										</xsl:when>
									</xsl:choose>
								</tr>
								<xsl:if test="$isAmendments != 'false' and (../ipcEntry[@version='2']/amendment or ../ipcEntry[@version='1']/amendment)">
									<tr>
										<td colspan="2">
											<table width="100%">
												<tr>
													<td width="10%">
														<xsl:call-template name="nbsp"/>
													</td>
													<td>
														<table class="amendment">
															<xsl:apply-templates select="../ipcEntry[@version='1']/amendment" mode="withintext"/>
														</table>
													</td>
												</tr>
											</table>
										</td>
										<td colspan="2">
											<table width="100%">
												<tr>
													<td width="10%">
														<xsl:call-template name="nbsp"/>
													</td>
													<td>
														<table class="amendment">
															<xsl:apply-templates select="../ipcEntry[@version='2']/amendment" mode="withintext"/>
														</table>
													</td>
												</tr>
											</table>
										</td>
									</tr>
								</xsl:if>
							</table>
						</td>
                    </tr>
                </table>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="$isquery='true'">
            <hr/>
        </xsl:if>
    </xsl:template>
	<xsl:template name="ipcentry-col-2">
		<xsl:param name="style" />
		<td align="left" width="49%" class="{$style}">
			<xsl:call-template name="nbsp"/>
		</td>
		<td align="left" width="2%" class="{$style}">
			<xsl:call-template name="nbsp"/>
		</td>
		<td align="left" width="49%" class="{$style}">
			<xsl:apply-templates select="../ipcEntry[@version='2']/textBody"/>
			<xsl:if test="../ipcEntry[@version='2']/@edition">
				<span class="e">
					<xsl:call-template name="nbsp"/>
					<xsl:call-template name="nbsp"/>[<xsl:call-template name="mergeedition"><xsl:with-param name="edition" select="../ipcEntry[@version='2']/@edition"/></xsl:call-template>]</span>
			</xsl:if>
		    <!-- <xsl:if test="@remark"><P class="remark"><xsl:value-of select="@remark"/></P></xsl:if> -->
	  	</td>
	</xsl:template>
	<xsl:template name="ipcentry-col-1">
		<xsl:param name="style" />
			<td align="left" width="49%" class="{$style}">
				<xsl:if test="@kind = 'l'"><hr/></xsl:if>
				<xsl:apply-templates select="textBody"/>
			<xsl:if test="@edition">
				<span class="e">
					<xsl:call-template name="nbsp"/>
					<xsl:call-template name="nbsp"/>[<xsl:call-template name="getEdition"/>"/>]</span>
			</xsl:if>
		</td>
		<td align="left" width="2%" class="{$style}">
			<xsl:call-template name="nbsp"/>
		</td>
		<xsl:choose>
			<xsl:when test="../ipcEntry[@version='2']">
				<td align="left" width="49%" class="{$style}">
					<xsl:apply-templates select="../ipcEntry[@version='2']/textBody"/>
					<xsl:if test="../ipcEntry[@version='2']/@edition">
						<span class="e">
							<xsl:call-template name="nbsp"/>
							<xsl:call-template name="nbsp"/>[<xsl:call-template name="mergeedition"><xsl:with-param name="edition" select="../ipcEntry[@version='2']/@edition"/></xsl:call-template>]</span>
					</xsl:if>
                    <!-- <xsl:if test="@remark"><P class="remark"><xsl:value-of select="@remark"/></P></xsl:if> -->
				</td>
			</xsl:when>
			<xsl:otherwise>
				<td align="left" width="49%" class="{$style}">
					<xsl:call-template name="nbsp"/>
				</td>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

    <xsl:template name="id">
        <xsl:param name="kind"/>
        <xsl:param name="style"/>
        <xsl:param name="kindstyle"/>
		<xsl:choose>
			<xsl:when test="@endSymbol">
				<a name="ipc{@symbol}{@endSymbol}"/>
			</xsl:when>
			<xsl:otherwise>
				<a name="ipc{@symbol}"/>
			</xsl:otherwise>
		</xsl:choose>
        <xsl:choose>
            <xsl:when test="$kind = 's' or $kind = 'c' or $kind='u' or ($kind='d' and 5 &gt; string-length(@symbol))">
                <td width="100">
					<xsl:attribute name="class">
						<xsl:if test="$kind = 'm' or $kind = 'u'">i</xsl:if><xsl:value-of select="$style"/>
					</xsl:attribute>

					    <xsl:if test="@isDead='Y'">
				                <xsl:attribute name="style">:  ;background-image:url(<xsl:value-of select="concat($admingiffolder,'dead.gif')"/>)</xsl:attribute>
					    </xsl:if>
					<span class="{$kindstyle}">
            <xsl:choose>
            <xsl:when test="$isquery">
                <a href="javascript:jump('{$displayMode}','{@symbol}','{$targetWindow}')">
                  <xsl:attribute name="title">
                  <xsl:choose>
                  <xsl:when test="substring-before($displayMode,'f') != ''">Fulltext...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'h') != ''">Hierarchy...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'a') != ''">Expanded...</xsl:when>
<!-- TA 20050217 text for STATIC changed, do not change for DYNAMIC -->
                  <xsl:otherwise>Open <xsl:value-of select="@symbol"/>...</xsl:otherwise>
                  </xsl:choose>
                  </xsl:attribute>
                  <!-- TA 20050215 <xsl:value-of select="@symbol"/> -->
		  <xsl:call-template name="styledsymbol"/>
                </a>
            </xsl:when>
            <xsl:when test="$isFulltext">
                <a href="javascript:jh('{$displayMode}','{@symbol}','{$targetWindow}')" title="Hierarchy...">
                  <!-- TA 20050215 <xsl:value-of select="@symbol"/> -->
		  <xsl:call-template name="styledsymbol"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
              <a href="javascript:jumpFulltext('{$displayMode}','{@symbol}','{$targetWindow}')" title="Fulltext...">
                  <!-- TA 20050215 <xsl:value-of select="@symbol"/> -->
		  <xsl:call-template name="styledsymbol"/>
              </a>
            </xsl:otherwise>
            </xsl:choose>
					</span>
				</td>
            </xsl:when>
            <xsl:when test="$kind = 'i'">
                <td width="100" class="i{$style}" >
					    <xsl:if test="@isDead='Y'">
				                <xsl:attribute name="style">:  ;background-image:url(<xsl:value-of select="concat($admingiffolder,'dead.gif')"/>)</xsl:attribute>
					    </xsl:if>
					<xsl:call-template name="dumpSymbolInterval"/>

				</td>
            </xsl:when>
            <xsl:when test="$kind = 'u' or $kind = 'n'">
                <td class="i{$style}" width="100">

					    <xsl:if test="@isDead='Y'">
				                <xsl:attribute name="style">:  ;background-image:url(<xsl:value-of select="concat($admingiffolder,'dead.gif')"/>)</xsl:attribute>
					    </xsl:if>
					<xsl:call-template name="dumpSymbolInterval"/>
				</td>
            </xsl:when>
            <xsl:when test="$kind='g'">
                <td class="i{$style}" width="100">

					    <xsl:if test="@isDead='Y'">
				                <xsl:attribute name="style">:  ;background-image:url(<xsl:value-of select="concat($admingiffolder,'dead.gif')"/>)</xsl:attribute>
					    </xsl:if>
					<xsl:call-template name="dumpSymbolInterval"/>
				</td>
            </xsl:when>
            <xsl:when test="$kind='d'">
                <td width="100">
					<xsl:attribute name="class">
						<xsl:if test="$kind = 'm' or $kind = 'u'">i</xsl:if>
						<xsl:value-of select="$style"/>
					</xsl:attribute>
					    <xsl:if test="@isDead='Y'">
				                <xsl:attribute name="style">:  ;background-image:url(<xsl:value-of select="concat($admingiffolder,'dead.gif')"/>)</xsl:attribute>
					    </xsl:if>
					<xsl:call-template name="dumpSymbolInterval"/>
				</td>
            </xsl:when>
            <xsl:when test="$kind = 't' or $kind='l'">
                <td class="gi" width="100">
					<xsl:call-template name="nbsp"/>
				</td>
            </xsl:when>
            <xsl:when test="$isquery">
                <xsl:variable name="ipcid" select="@symbol"/>
                <td width="100">
					<xsl:attribute name="class">
						<xsl:if test="$kind = 'm' or $kind = 'u'">i</xsl:if>
						<xsl:value-of select="$style"/>
				</xsl:attribute>
<!-- TA 20050217, not needed in STATIC version, but needed in DYNAMIC
                <a href="javascript:jump('{$displayMode}','{@symbol}','{$targetWindow}')">
                  <xsl:attribute name="title">
                  <xsl:choose>
                  <xsl:when test="substring-before($displayMode,'f') != ''">Fulltext...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'h') != ''">Hierarchy...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'a') != ''">Expanded...</xsl:when>
                  <xsl:otherwise></xsl:otherwise>
                  </xsl:choose>
                  </xsl:attribute>
		<xsl:attribute name="href"></xsl:attribute>
-->
		<!-- TA 20050215 -->
		   <xsl:if test="@edition='new' or substring-before(@edition,'c-mod')!='' or substring-before(@edition,$actualEdition)!='' or @edition=$actualEdition">
			<xsl:attribute name="style">font-style:italic</xsl:attribute>
		   </xsl:if>
		      <xsl:call-template name="ref"><xsl:with-param name="ref" select="$ipcid"/></xsl:call-template>
<!--
                      <xsl:value-of select="substring($ipcid,1,4)"/>
                      <xsl:call-template name="nbsp"/>
                      <xsl:value-of select="concat(number(substring($ipcid,5,3)),'/',substring($ipcid,8,string-length($ipcid)))"/>
-->
<!-- TA 20050217, not needed in STATIC version, but needed in DYNAMIC
                </a>
-->
        </td>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="ipcid" select="@symbol"/>
                <td class="{$style}" width="100">
          <xsl:variable name="targetMode">
              <xsl:choose>
              <xsl:when test="$isFulltext='false'">f</xsl:when>
              <xsl:otherwise>h</xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
           <xsl:variable name="titleText">
              <xsl:choose>
              <xsl:when test="$isFulltext='false'">Fulltext...</xsl:when>
              <xsl:otherwise>Hierarchy...</xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
          <a href="javascript:jumpMode('{$displayMode}','{$targetMode}','{@symbol}','{$targetWindow}');" title="{$titleText}">
            <xsl:value-of select="substring($ipcid,1,4)"/>
						<xsl:call-template name="nbsp"/>
						<xsl:value-of select="concat(number(substring($ipcid,5,3)),'/',substring($ipcid,8,string-length($ipcid)))"/>
					</a>
				</td>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


	<!-- TA 2005014 -->
    <xsl:template name="styledsymbol">
	<xsl:choose>
	<xsl:when test="@edition='new' or substring-before(@edition,'c-mod')!='' or substring-before(@edition,$actualEdition)!='' or @edition=$actualEdition">
		<i><xsl:value-of select="@symbol"/></i>
	</xsl:when>
	<xsl:otherwise>
		<xsl:value-of select="@symbol"/>
	</xsl:otherwise>
	</xsl:choose>
    </xsl:template>

	<xsl:template name="dots">
		<xsl:param name="kind"/>
		<xsl:param name="style"/>
		<xsl:choose>
			<xsl:when test="$kind = 'group1' or $kind='1'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group2' or $kind='2'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group3' or $kind='3'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group4' or $kind='4'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  ·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group5' or $kind='5'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  ·  ·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group6' or $kind='6'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  ·  ·  ·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group7' or $kind='7'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  ·  ·  ·  ·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group8' or $kind='8'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  ·  ·  ·  ·  ·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group9' or $kind='9'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  ·  ·  ·  ·  ·  ·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:when test="$kind = 'group10' or $kind='A'">
				<td class="dot-{$style}">
					<span class="dot-{$style}">
						<xsl:text disable-output-escaping="yes">·  ·  ·  ·  ·  ·  ·  ·  ·  ·  </xsl:text>
					</span>
				</td>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

    <xsl:template match="textBody">
	<xsl:choose>
	<xsl:when test="../@edition='new' or substring-before(../@edition,'c-mod')!='' or substring-before(../@edition,$actualEdition)!='' or ../@edition=$actualEdition">
		<i><xsl:apply-templates/></i>
	</xsl:when>
	<xsl:otherwise>
		<xsl:apply-templates/>
	</xsl:otherwise>
	</xsl:choose>
    </xsl:template>
    <xsl:template match="title">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="title" mode="single">
        <xsl:apply-templates mode="single"/>
    </xsl:template>
    <xsl:template match="titlePart" mode="single">
        <span tag="titlePart" class="{../../../@kind}">
            <xsl:apply-templates select="text" mode="single"/>
        </span>
        <xsl:if test="entryReference">
            <span tag="entryReference" class="ref">
                <xsl:text> </xsl:text>(<xsl:apply-templates select="entryReference"/>)<!-- <xsl:text> </xsl:text> --></span>
        </xsl:if>
        <xsl:if test="following-sibling::titlePart">;<xsl:text> </xsl:text></xsl:if>
    </xsl:template>
    <xsl:template match="entryReference" mode="single">
        <span tag="entryReference">
            <xsl:apply-templates mode="single"/>
            <xsl:choose>
                <xsl:when test="following-sibling::entryReference">
                    <span tag="drop">;<xsl:text> </xsl:text></span>
                </xsl:when>
                <xsl:otherwise>
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    <xsl:template match="titlePart">
        <span>
            <xsl:attribute name="class">
				<xsl:choose>
				<xsl:when test="../../../@kind"><xsl:value-of select="../../../@kind"/></xsl:when>
				<xsl:when test="../../@kind"><xsl:value-of select="../../@kind"/></xsl:when>
				</xsl:choose>
			</xsl:attribute>
            <xsl:apply-templates select="text"/>
        </span>
        <xsl:if test="entryReference">
            <span class="ref">
                <xsl:text> </xsl:text>(<xsl:apply-templates select="entryReference"/>)<!-- <xsl:text> </xsl:text> --></span>
        </xsl:if>
        <xsl:if test="following-sibling::titlePart">;<xsl:text> </xsl:text></xsl:if>
    </xsl:template>
    <xsl:template match="entryReference">
        <xsl:apply-templates/>
        <xsl:choose>
            <xsl:when test="following-sibling::entryReference">;<xsl:text> </xsl:text></xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="text">
        <xsl:apply-templates/>
	<xsl:choose>
        <xsl:when test="../@mod-edition!=''">
            <xsl:call-template name="nbsp"/>
            <span class="e">[<xsl:value-of select="../@mod-edition"/>]</span>
        </xsl:when>
        <xsl:when test="../@edition!=''">
            <xsl:call-template name="nbsp"/>
            <span class="e">[<xsl:call-template name="mergeedition"><xsl:with-param name="edition" select="../@edition"/></xsl:call-template>]</span>
        </xsl:when>
        <xsl:when test="../@new-edition!=''">
            <xsl:call-template name="nbsp"/>
            <span class="e">[<xsl:value-of select="../@new-edition"/>]</span>
        </xsl:when>
	<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
    </xsl:template>
    <xsl:template match="note" mode="single">

       <xsl:if test="not(preceding-sibling::*)">
			<xsl:variable name="noteText"><xsl:call-template name="translate"><xsl:with-param name="id">Note(s)</xsl:with-param></xsl:call-template></xsl:variable>

      <xsl:choose>
      <xsl:when test="../@edition='new' or substring-before(../@edition,'c-mod')!='' or substring-before(../@edition,$actualEdition)!='' or ../@edition=$actualEdition">
        <i><p><xsl:value-of select="$noteText"/></p></i>
      </xsl:when>
      <xsl:otherwise>
        <p><xsl:value-of select="$noteText"/></p>
      </xsl:otherwise>
      </xsl:choose>
        </xsl:if>
        <span tag="note" type="{@type}">
            <xsl:choose>
                <xsl:when test="@type='number'">
                    <ol>
                        <xsl:apply-templates select="noteParagraph" mode="single"/>
                    </ol>
                </xsl:when>
                <xsl:when test="@type='bullet'">
                    <ul>
                        <xsl:apply-templates select="noteParagraph" mode="single"/>
                    </ul>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="noteParagraph" mode="p"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="orphan" mode="single"/>
        </span>
    </xsl:template>
    <xsl:template match="orphan" mode="single">
        <span tag="orphan">
            <p class="o{@indent}"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                <xsl:apply-templates select="text"/>
<!-- 20050401 TA double orphan
                <xsl:if test="@edition !=''">
                    <xsl:call-template name="nbsp"/>
                    <span class="e">[<xsl:call-template name="getEdition"/>]</span>
                </xsl:if>
-->
            </p>
            <xsl:apply-templates select="subnote" mode="single"/>
            <xsl:apply-templates select="orphan" mode="single"/>
        </span>
    </xsl:template>
    <xsl:template match="subnote" mode="single">
        <span tag="subnote">
            <xsl:choose>
                <xsl:when test="@type='number'">
                    <ol>
                        <xsl:apply-templates select="noteParagraph"/>
                    </ol>
                </xsl:when>
                <xsl:when test="@type='bullet'">
                    <ul>
                        <xsl:apply-templates select="noteParagraph"/>
                    </ul>
                </xsl:when>
                <xsl:when test="@type='roman'">
                    <ol type="i">
                        <xsl:apply-templates select="noteParagraph"/>
                    </ol>
                </xsl:when>
                <xsl:when test="@type='Roman'">
                    <ol type="I">
                        <xsl:apply-templates select="noteParagraph" mode="single"/>
                    </ol>
                </xsl:when>
                <xsl:when test="@type='alpha'">
                    <ol type="a">
                        <xsl:apply-templates select="noteParagraph" mode="single"/>
                    </ol>
                </xsl:when>
                <xsl:when test="@type='Alpha'">
                    <ol type="A">
                        <xsl:apply-templates select="noteParagraph" mode="single"/>
                    </ol>
                </xsl:when>
                <xsl:when test="@type='table'">
                    <ol type="A">
                        <xsl:apply-templates select="noteParagraph" mode="single"/>
                    </ol>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="noteParagraph" mode="single-p"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="orphan" mode="single"/>
        </span>
    </xsl:template>
    <xsl:template match="noteParagraph" mode="single">
        <xsl:choose>
            <xsl:when test="references">
                <table width="100%">
                    <tr>
                        <td width="20%">
							<span tag="references">
							<xsl:choose>
							<xsl:when test="@edition='new' or substring-before(@edition,'c-mod')!=''  or substring-before(@edition,$actualEdition)!='' or @edition=$actualEdition">
								<i><xsl:apply-templates select="references"/></i>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="references"/>
							</xsl:otherwise>
							</xsl:choose>

							</span>
						</td>
                        <td width="80%">
							<span tag="text">
							<xsl:choose>
							<xsl:when test="@edition='new' or substring-before(@edition,'c-mod')!=''  or substring-before(@edition,$actualEdition)!='' or @edition=$actualEdition">
								<i><xsl:apply-templates select="text"/></i>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="text"/>
							</xsl:otherwise>
							</xsl:choose>
							</span>
						</td>
                    </tr>
                </table>
            </xsl:when>
            <xsl:when test="count(./text/nbsp) &gt; 4 and ../../@type != 'bullet'">
                <p class="pre"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                    <xsl:apply-templates/>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <li>
                        <xsl:call-template name="noteParagraphBelow"/>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="noteParagraphBelow">
			<xsl:choose>
			<xsl:when test="@edition='new' or substring-before(@edition,'c-mod')!=''  or substring-before(@edition,$actualEdition)!='' or @edition=$actualEdition">
				<i><xsl:apply-templates/></i>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
			</xsl:choose>
    </xsl:template>
    <xsl:template match="noteParagraph" mode="single-p">
        <span tag="noteParagraph">
            <xsl:choose>
                <xsl:when test="../@indent and ../../../@indent">
                    <p class="{concat('p',../@indent - ../../../@indent)}"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                        <xsl:call-template name="noteParagraphBelow"/>
                        <xsl:if test="@edition !=''">
                            <xsl:call-template name="nbsp"/>
                            <span class="e">[<xsl:call-template name="getEdition"/>]</span>
                        </xsl:if>
                    </p>
                </xsl:when>
                <xsl:when test="count(.//nbsp)&gt;1 and ../../@type != 'bullet'">
                    <p class="pre"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                        <xsl:call-template name="noteParagraphBelow"/>
                        <xsl:if test="@edition !=''">
                            <xsl:call-template name="nbsp"/>
                            <span class="e">[<xsl:call-template name="getEdition"/>]</span>
                        </xsl:if>
                    </p>
                </xsl:when>
                <xsl:otherwise>
                    <p class="p"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                        <xsl:call-template name="noteParagraphBelow"/>
                        <xsl:if test="@edition !=''">
                            <xsl:call-template name="nbsp"/>
                            <span class="e">[<xsl:call-template name="getEdition"/>]</span>
                        </xsl:if>
                    </p>
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    <xsl:template match="index" mode="single">
        <span tag="index">
            <table width="100%" border="0" cellpadding="0" cellspacing="0">
                <tr>
                    <td class="index">
						<span tag="drop">
							<xsl:choose>
								<xsl:when test="string-length(@symbol)=4 and (@lang='FR' or ../@lang='FR')">Schéma général</xsl:when>
								<xsl:when test="string-length(@symbol)=4 and @lang='EN'">Subclass index</xsl:when>
								<xsl:when test="string-length(@symbol)=3 and (@lang='FR' or ../@lang='FR')">Schéma général</xsl:when>
								<xsl:when test="string-length(@symbol)=3 and @lang='EN'">Class index</xsl:when>
								<xsl:otherwise>Subclass index</xsl:otherwise>
							</xsl:choose>
						</span>
					</td>
                </tr>
                <tr>
                    <td>
						<table width="100%" cellpadding="0" cellspacing="0">
							<xsl:for-each select="indexEntry">
								<xsl:call-template name="indexEntrySingle">
									<xsl:with-param name="d">1</xsl:with-param>
								</xsl:call-template>
							</xsl:for-each>
						</table>
					</td>
                </tr>
            </table>
        </span>
    </xsl:template>
    <xsl:template name="indexEntrySingle">
        <xsl:param name="d"/>
        <tr>
            <td style="padding-left:{$d*20}px" width="70%">
				<span tag="text">
					<xsl:apply-templates select="text"/>
				</span>
			</td>
            <td>
				<span tag="references">
					<xsl:apply-templates select="references"/>
				</span>
			</td>
        </tr>
        <xsl:if test="indexEntry">
            <xsl:for-each select="indexEntry">
                <xsl:call-template name="indexEntrySingle">
                    <xsl:with-param name="d" select="number($d)+1"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    <xsl:template match="note">
        <xsl:if test="not(preceding-sibling::*)">
				<xsl:variable name="noteText"><xsl:call-template name="translate"><xsl:with-param name="id">Note(s)</xsl:with-param></xsl:call-template></xsl:variable>
      <xsl:choose>
      <xsl:when test="../@edition='new' or substring-before(../@edition,'c-mod')!=''  or substring-before(../@edition,$actualEdition)!='' or ../@edition=$actualEdition">
        <i><p><xsl:value-of select="$noteText"/></p></i>
      </xsl:when>
      <xsl:otherwise>
        <p><xsl:value-of select="$noteText"/></p>
      </xsl:otherwise>
      </xsl:choose>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="@type='number'">
                <ol>
                    <xsl:apply-templates select="noteParagraph"/>
                </ol>
            </xsl:when>
            <xsl:when test="@type='bullet'">
                <ul>
                    <xsl:apply-templates select="noteParagraph"/>
                </ul>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="noteParagraph" mode="p"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="orphan"/>
    </xsl:template>
    <xsl:template match="orphan">
      <div class="o{@indent}">
            <xsl:apply-templates select="text"/>
<!-- 20050401 TA double orphan
            <xsl:if test="@edition !=''">
                <xsl:call-template name="nbsp"/>
                <span class="e">[<xsl:call-template name="getEdition"/>]</span>
            </xsl:if>
-->
        </div>
        <xsl:apply-templates select="subnote"/>
        <xsl:apply-templates select="orphan"/>
    </xsl:template>
    <xsl:template match="subnote">
        <xsl:choose>
            <xsl:when test="@type='number'">
                <ol>
                    <xsl:apply-templates select="noteParagraph"/>
                </ol>
            </xsl:when>
            <xsl:when test="@type='bullet'">
                <ul>
                    <xsl:apply-templates select="noteParagraph"/>
                </ul>
            </xsl:when>
            <xsl:when test="@type='roman'">
                <ol type="i">
                    <xsl:apply-templates select="noteParagraph"/>
                </ol>
            </xsl:when>
            <xsl:when test="@type='Roman'">
                <ol type="I">
                    <xsl:apply-templates select="noteParagraph"/>
                </ol>
            </xsl:when>
            <xsl:when test="@type='alpha'">
                <ol type="a">
                    <xsl:apply-templates select="noteParagraph"/>
                </ol>
            </xsl:when>
            <xsl:when test="@type='Alpha'">
                <ol type="A">
                    <xsl:apply-templates select="noteParagraph"/>
                </ol>
            </xsl:when>
            <xsl:when test="@type='table'">
                <!-- <ol type="A"> -->
                    <xsl:apply-templates select="noteParagraph"/>
                <!-- </ol> -->
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="noteParagraph" mode="p"/>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="orphan"/>
    </xsl:template>
    <xsl:template match="noteParagraph">
        <xsl:choose>
            <xsl:when test="references">
                <table width="100%">
                    <tr>
                        <td width="20%">
							<span tag="references">
							<xsl:choose>
							<xsl:when test="@edition='new' or substring-before(@edition,'c-mod')!=''  or substring-before(@edition,$actualEdition)!='' or @edition=$actualEdition">
								<i><xsl:apply-templates select="references"/></i>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="references"/>
							</xsl:otherwise>
							</xsl:choose>

							</span>
						</td>
                        <td>
							<xsl:choose>
							<xsl:when test="@edition='new' or substring-before(@edition,'c-mod')!=''  or substring-before(@edition,$actualEdition)!='' or @edition=$actualEdition">
								<i><xsl:apply-templates select="text"/></i>
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="text"/>
							</xsl:otherwise>
							</xsl:choose>
						</td>
			<td width="80px"><xsl:call-template name="nbsp"/></td>
                    </tr>
                </table>
            </xsl:when>
            <xsl:when test="count(./text/nbsp) &gt; 4 and ../../@type != 'bullet'">
                <p class="pre"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                    <xsl:apply-templates/>
                </p>
            </xsl:when>
			<xsl:when test="../@type = 'none'">
				<p>
					<xsl:call-template name="noteParagraphBelow"/>
				</p>
			</xsl:when>
            <xsl:otherwise>
                <li>
                    <xsl:call-template name="noteParagraphBelow"/>
                </li>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="noteParagraph" mode="p">
        <xsl:choose>
            <xsl:when test="../@indent and ../../../@indent">
                <p class="{concat('p',../@indent - ../../../@indent)}"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                    <xsl:apply-templates/>
                    <!-- TA 2004-MAY-02: edition sign is maintained by text!
					<xsl:if test="not(subnote)">
	                    <xsl:if test="@edition !=''">
	                        <xsl:call-template name="nbsp"/>
	                        <span class="e">[<xsl:call-template name="getEdition"/>]</span>
	                    </xsl:if>
					</xsl:if>
			-->
                </p>
            </xsl:when>
            <xsl:when test="count(.//nbsp)&gt;1 and ../../@type != 'bullet'">
                <p class="pre"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                    <xsl:apply-templates/>
                    <xsl:if test="@edition !=''">
                        <xsl:call-template name="nbsp"/>
                        <span class="e">[<xsl:call-template name="getEdition"/>]</span>
                    </xsl:if>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <p class="p"><!-- 20040929 TA move to span <div style="display:none"></div> -->
                    <xsl:apply-templates/>
                    <!-- TA 2004-MAR-02: edition sign is maintained by text!
					<xsl:if test="not(subnote)">
						<xsl:if test="@edition !=''">
							<xsl:call-template name="nbsp"/>
							<span class="e">[<xsl:call-template name="getEdition"/>]</span>
						</xsl:if>
					</xsl:if>
-->
                </p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="index">
        <table width="100%" border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td class="index">
							<xsl:choose>
								<xsl:when test="string-length(../../@symbol)=4"><xsl:call-template name="translate"><xsl:with-param name="id">Subclass index</xsl:with-param></xsl:call-template></xsl:when>
								<xsl:when test="string-length(../../@symbol)=3 and string-length(../../@endSymbol)=0"><xsl:call-template name="translate"><xsl:with-param name="id">Class index</xsl:with-param></xsl:call-template></xsl:when>
								<xsl:when test="string-length(../../@symbol)=3 and string-length(../../@endSymbol)=3"><xsl:call-template name="translate"><xsl:with-param name="id">Subsection index</xsl:with-param></xsl:call-template></xsl:when>
								<xsl:otherwise>Subclass index</xsl:otherwise>
							</xsl:choose>
				</td>
            </tr>
            <tr>
                <td>
					<table width="100%" cellpadding="0" cellspacing="0">
						<xsl:for-each select="indexEntry">
							<xsl:call-template name="indexEntry">
								<xsl:with-param name="d">1</xsl:with-param>
							</xsl:call-template>
						</xsl:for-each>
					</table>
				</td>
            </tr>
        </table>
    </xsl:template>
    <xsl:template name="indexEntry">
        <xsl:param name="d"/>
        <tr>
            <td style="padding-left:{$d*20}px" width="70%">
				<xsl:apply-templates select="text"/>
			</td>
            <td>
				<xsl:apply-templates select="references"/>
			</td>
        </tr>
        <xsl:if test="indexEntry">
            <xsl:for-each select="indexEntry">
                <xsl:call-template name="indexEntry">
                    <xsl:with-param name="d" select="number($d)+1"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    <xsl:template match="sref" mode="delete">
        <xsl:if test="preceding-sibling::mref or preceding-sibling::sref">,<xsl:text> </xsl:text></xsl:if>
        <xsl:variable name="id"><xsl:call-template name="guid"/></xsl:variable>
        <xsl:if test="not(/EDITOR) and $skippopup='0'">
            <span id="{$id}_div" style="display: none">
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'f'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'h'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'a'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
            </span>
        </xsl:if>
        <a
			href="javascript:jump('{$displayMode}','{@ref}','{$targetWindow}')"
			id="$id">
            <xsl:if test="not(/EDITOR)">
                <xsl:attribute name="onmouseover">
					<xsl:text>overlib(</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>_div.innerHTML, REF, '</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>');</xsl:text>
				</xsl:attribute>
                <xsl:attribute name="onmouseout">
					<xsl:text>nd(2000);</xsl:text>
				</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="title">
				<xsl:choose>
	                <xsl:when test="substring-before($displayMode,'f') != ''">Fulltext...</xsl:when>
	                <xsl:when test="substring-before($displayMode,'h') != ''">Hierarchy...</xsl:when>
	                <xsl:when test="substring-before($displayMode,'a') != ''">Expanded...</xsl:when>
					<xsl:otherwise>Other mode...</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
            <xsl:call-template name="ref">
                <xsl:with-param name="ref" select="@ref"/>
            </xsl:call-template>
        </a>
    </xsl:template>
    <xsl:template match="mref" mode="delete">
        <xsl:if test="preceding-sibling::mref or preceding-sibling::sref">,</xsl:if>
        <xsl:variable name="id"><xsl:call-template name="guid"/></xsl:variable>
        <xsl:if test="not(/EDITOR) and $skippopup='0'">
            <span id="{$id}1_div" style="display: none">
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'f'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'h'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'a'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
            </span>
            <span id="{$id}2_div" style="display: none">
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'f'"/>
                    <xsl:with-param name="ref" select="@endRef"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'h'"/>
                    <xsl:with-param name="ref" select="@endRef"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'a'"/>
                    <xsl:with-param name="ref" select="@endRef"/>
                </xsl:call-template>
            </span>
        </xsl:if>
        <a href="javascript:jump('{$displayMode}','{@ref}','{$targetWindow}')"
			id="{$id}1">
            <xsl:if test="not(/EDITOR)">
                <xsl:attribute name="onmouseover">
					<xsl:text>overlib(</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>1_div.innerHTML, REF, '</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>1');</xsl:text>
				</xsl:attribute>
                <xsl:attribute name="onmouseout">
					<xsl:text>nd(2000);</xsl:text>
				</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="title">
                  <xsl:choose>
                  <xsl:when test="substring-before($displayMode,'f') != ''">Fulltext...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'h') != ''">Hierarchy...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'a') != ''">Expanded...</xsl:when>
                  <xsl:otherwise>Other mode...</xsl:otherwise>
                  </xsl:choose>
                  </xsl:attribute>
            <xsl:call-template name="ref">
                <xsl:with-param name="ref" select="@ref"/>
            </xsl:call-template>
        </a>
        <xsl:value-of select="$to"/>
        <a href="javascript:jump('{$displayMode}','{@endRef}','{$targetWindow}')"
			id="{$id}2">
            <xsl:if test="not(/EDITOR)">
                <xsl:attribute name="onmouseover">
					<xsl:text>overlib(</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>2_div.innerHTML, REF, '</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>2');</xsl:text>
				</xsl:attribute>
                <xsl:attribute name="onmouseout">
					<xsl:text>nd(2000);</xsl:text>
				</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="title">
                  <xsl:choose>
                  <xsl:when test="substring-before($displayMode,'f') != ''">Fulltext...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'h') != ''">Hierarchy...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'a') != ''">Expanded...</xsl:when>
                  <xsl:otherwise>Other mode...</xsl:otherwise>
                  </xsl:choose>
                  </xsl:attribute>
            <xsl:call-template name="ref">
                <xsl:with-param name="ref" select="@endRef"/>
            </xsl:call-template>
        </a>
    </xsl:template>
    <xsl:template name="guid">
<!--        <xsl:text>idL</xsl:text>
        <xsl:for-each select="ancestor::*">
            <xsl:value-of select="count(preceding-sibling::*)"/>
        </xsl:for-each>
        <xsl:value-of select="@ref"/>-->
		<xsl:value-of select="generate-id()"/>
    </xsl:template>
    <xsl:template name="echodisplaymode">
        <xsl:param name="char"/>
        <xsl:param name="ref"/>
        <a>
            <xsl:attribute name="href">
			 	<xsl:text>javascript:jumpDirect('</xsl:text>
				<xsl:choose>
					<xsl:when test="substring-before($displayMode,'f') != ''">
						<xsl:value-of select="substring-before($displayMode,'f')"/>
						<xsl:value-of select="$char"/>
						<xsl:value-of select="substring-after($displayMode,'f')"/>
					</xsl:when>
					<xsl:when test="substring-before($displayMode,'h') != ''">
						<xsl:value-of select="substring-before($displayMode,'h')"/>
						<xsl:value-of select="$char"/>
						<xsl:value-of select="substring-after($displayMode,'h')"/>
					</xsl:when>
					<xsl:when test="substring-before($displayMode,'a') != ''">
						<xsl:value-of select="substring-before($displayMode,'a')"/>
						<xsl:value-of select="$char"/>
						<xsl:value-of select="substring-after($displayMode,'a')"/>
					</xsl:when>
				</xsl:choose>
				<xsl:text>','</xsl:text>
				<xsl:value-of select="$ref"/>
				<xsl:text>','</xsl:text>
				<xsl:value-of select="$targetWindow"/>
				<xsl:text>');</xsl:text>
			</xsl:attribute>
            <xsl:choose>
                <xsl:when test="$char='f'">Fulltext...</xsl:when>
                <xsl:when test="$char='h'">Hierarchy...</xsl:when>
                <xsl:when test="$char='a'">Expanded...</xsl:when>
            </xsl:choose>
        </a>
    </xsl:template>
    <xsl:template match="sref">
		<xsl:call-template name="addprespace"/>
        <xsl:variable name="id"><xsl:call-template name="guid"/></xsl:variable>
        <xsl:if test="not(/EDITOR) and $skippopup='0'">
            <span id="{$id}_div" style="display: none">
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'f'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'h'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'a'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
            </span>
        </xsl:if>
        <a
			href="javascript:jump('{$displayMode}','{@ref}','{$targetWindow}')"
			class="ref-{@ipcLevel}"
			id="{$id}">
            <xsl:if test="not(/EDITOR)">
                <xsl:attribute name="onmouseover">
					<xsl:text>overlib(</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>_div.innerHTML, REF, '</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>');</xsl:text>
				</xsl:attribute>
                <xsl:attribute name="onmouseout">
					<xsl:text>nd(2000);</xsl:text>
				</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="title">
              <xsl:choose>
                  <xsl:when test="substring-before($displayMode,'f') != ''">Fulltext...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'h') != ''">Hierarchy...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'a') != ''">Expanded...</xsl:when>
                  <xsl:otherwise>Other mode...</xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <xsl:call-template name="ref">
                <xsl:with-param name="ref" select="@ref"/>
            </xsl:call-template>
        </a>
    </xsl:template>
    <xsl:template match="mref">
		<xsl:call-template name="addprespace"/>
        <xsl:variable name="id"><xsl:call-template name="guid"/></xsl:variable>
        <xsl:if test="not(/EDITOR) and $skippopup='0'">
            <span id="{$id}1_div" style="display: none">
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'f'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'h'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'a'"/>
                    <xsl:with-param name="ref" select="@ref"/>
                </xsl:call-template>
            </span>
            <span id="{$id}2_div" style="display: none">
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'f'"/>
                    <xsl:with-param name="ref" select="@endRef"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'h'"/>
                    <xsl:with-param name="ref" select="@endRef"/>
                </xsl:call-template>
                <br/>
                <xsl:call-template name="echodisplaymode">
                    <xsl:with-param name="char" select="'a'"/>
                    <xsl:with-param name="ref" select="@endRef"/>
                </xsl:call-template>
            </span>
        </xsl:if>
        <a href="javascript:jump('{$displayMode}','{@ref}','{$targetWindow}')"
			class="ref-{@ipcLevel}"
			id="{$id}1">
            <xsl:if test="not(/EDITOR)">
                <xsl:attribute name="onmouseover">
					<xsl:text>overlib(</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>1_div.innerHTML, REF, '</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>1');</xsl:text>
				</xsl:attribute>
                <xsl:attribute name="onmouseout">
					<xsl:text>nd(2000);</xsl:text>
				</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="title">
                  <xsl:choose>
                  <xsl:when test="substring-before($displayMode,'f') != ''">Fulltext...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'h') != ''">Hierarchy...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'a') != ''">Expanded...</xsl:when>
                  <xsl:otherwise>Other mode...</xsl:otherwise>
                  </xsl:choose>
                  </xsl:attribute>
            <xsl:call-template name="ref">
                <xsl:with-param name="ref" select="@ref"/>
            </xsl:call-template>
        </a>
        <xsl:value-of select="$to"/>
        <a href="javascript:jump('{$displayMode}','{@endRef}','{$targetWindow}')"
			class="ref-{@ipcLevel}"
			id="{$id}2">
            <xsl:if test="not(/EDITOR)">
                <xsl:attribute name="onmouseover">
					<xsl:text>overlib(</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>2_div.innerHTML, REF, '</xsl:text>
					<xsl:value-of select="$id"/>
					<xsl:text>2');</xsl:text>
				</xsl:attribute>
                <xsl:attribute name="onmouseout">
					<xsl:text>nd(2000);</xsl:text>
				</xsl:attribute>
            </xsl:if>
            <xsl:attribute name="title">
                  <xsl:choose>
                  <xsl:when test="substring-before($displayMode,'f') != ''">Fulltext...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'h') != ''">Hierarchy...</xsl:when>
                  <xsl:when test="substring-before($displayMode,'a') != ''">Expanded...</xsl:when>
                  <xsl:otherwise>Other mode...</xsl:otherwise>
                  </xsl:choose>
                  </xsl:attribute>
            <xsl:call-template name="ref">
                <xsl:with-param name="ref" select="@endRef"/>
            </xsl:call-template>
        </a>
    </xsl:template>
    <xsl:template name="ref">
        <xsl:param name="ref"/>
        <xsl:param name="forceRefType"/>
        <xsl:variable name="myRefType">
		<xsl:choose>
		<xsl:when test="@refType">
			<xsl:value-of select="@refType"/>
		</xsl:when>
		<xsl:when test="$forceRefType=''">/</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$forceRefType"/>
		</xsl:otherwise></xsl:choose>
		</xsl:variable>
        <xsl:choose>
            <xsl:when test="4 &gt;= string-length($ref)">
                <xsl:value-of select="$ref"/>
            </xsl:when>
            <xsl:when test="14 = string-length($ref)">

		<xsl:value-of select="concat(substring($ref,1,4),' ',number(substring($ref,5,4)),$myRefType)"/>
		<xsl:variable name="group" select="substring($ref,9,6)"/>
		<xsl:choose>
		<xsl:when test="$group='000000'">00</xsl:when>
		<xsl:when test="substring($group,3,4)='0000'"><xsl:value-of select="substring($group,1,2)"/></xsl:when>
		<xsl:when test="substring($group,4,3)='000'"><xsl:value-of select="substring($group,1,3)"/></xsl:when>
		<xsl:when test="substring($group,5,2)='00'"><xsl:value-of select="substring($group,1,4)"/></xsl:when>
		<xsl:when test="substring($group,6,1)='0'"><xsl:value-of select="substring($group,1,5)"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$group"/></xsl:otherwise>
		</xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($ref,1,4),' ',number(substring($ref,5,3)),$myRefType,substring($ref,8,string-length($ref)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="indexref">
        <xsl:param name="ref"/>
        <xsl:param name="forceRefType"/>
	<xsl:variable name="noSubclass" select="ancestor::ipcEntry/@kind='u'"/>

        <xsl:variable name="myRefType">
		<xsl:choose>
		<xsl:when test="@refType">
			<xsl:value-of select="@refType"/>
		</xsl:when>
		<xsl:when test="$forceRefType=''">/</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$forceRefType"/>
		</xsl:otherwise></xsl:choose>
		</xsl:variable>
        <xsl:choose>
            <xsl:when test="4 &gt;= string-length($ref)">
                <xsl:value-of select="$ref"/>
            </xsl:when>
            <xsl:when test="14 = string-length($ref)">

		<xsl:if test="not($noSubclass)"><xsl:value-of select="concat(substring($ref,1,4),' ')"/></xsl:if>
		<xsl:value-of select="concat(number(substring($ref,5,4)),$myRefType)"/>
		<xsl:variable name="group" select="substring($ref,9,6)"/>
		<xsl:choose>
		<xsl:when test="$group='000000'">00</xsl:when>
		<xsl:when test="substring($group,3,4)='0000'"><xsl:value-of select="substring($group,1,2)"/></xsl:when>
		<xsl:when test="substring($group,4,3)='000'"><xsl:value-of select="substring($group,1,3)"/></xsl:when>
		<xsl:when test="substring($group,5,2)='00'"><xsl:value-of select="substring($group,1,4)"/></xsl:when>
		<xsl:when test="substring($group,6,1)='0'"><xsl:value-of select="substring($group,1,5)"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$group"/></xsl:otherwise>
		</xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($ref,1,4),' ',number(substring($ref,5,3)),$myRefType,substring($ref,8,string-length($ref)))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template match="index//sref">
        <span class="sref">
            <a href="javascript:jump('{$displayMode}','{@ref}','{$targetWindow}')">
	    <xsl:call-template name="indexref"><xsl:with-param name="ref" select="@ref"/></xsl:call-template>
            </a>
        </span>
    </xsl:template>
    <xsl:template match="flatNotes[@type='index']//sref">
        <span class="sref">
            <a title="Fulltext..." href="javascript:jumpMode('{$displayMode}','f','{@ref}','{$targetWindow}')">
                <xsl:value-of select="concat(number(substring(@ref,5,3)),@refType,substring(@ref,8,string-length(@ref)))"/>
            </a>
        </span>
    </xsl:template>
    <xsl:template match="flatNotes[@type='index']//mref">
        <span class="sref">
            <a title="Fulltext..." href="javascript:jumpMode('{$displayMode}','f','{@ref}','{$targetWindow}')">
                <xsl:value-of select="concat(number(substring(@ref,5,3)),@refType,substring(@ref,8,string-length(@ref)))"/>
            </a>
        </span>
    </xsl:template>
    <xsl:template match="index//mref">
        <xsl:variable name="myTargetS" select="./@ref"/>
        <xsl:variable name="myTargetE" select="./@endRef"/>
        <span class="sref">
            <a href="javascript:jump('{$displayMode}','{@ref}','{$targetWindow}')">
	    	<xsl:call-template name="indexref"><xsl:with-param name="ref" select="@ref"/></xsl:call-template>
            </a>
            <span class="to">
                <xsl:call-template name="nbsp"/>
                <xsl:value-of select="$to"/>
                <xsl:call-template name="nbsp"/>
            </span>
            <a href="javascript:jump('{$displayMode}','{@endRef}','{$targetWindow}')">
	    	<xsl:call-template name="indexref"><xsl:with-param name="ref" select="@endRef"/></xsl:call-template>
            </a>
        </span>
    </xsl:template>
    <xsl:template match="sub">
        <sub>
            <xsl:apply-templates/>
        </sub>
    </xsl:template>
    <xsl:template match="sup">
        <sup>
            <xsl:apply-templates/>
        </sup>
    </xsl:template>
    <xsl:template match="img">
        <xsl:variable name="formulafolder" select="'img/'"/>
	<!-- 20060210 TA removed
        <xsl:variable name="img">
	<xsl:choose>
	<xsl:when test="substring-before(@src,'.gif') != ''">
		<xsl:value-of select="concat($formulafolder, substring-before(translate(./@src,$uc,$lc),'.gif'),'.gif')"/>
	</xsl:when>
  <xsl:when test="substring-before(@src,'.') = ''">
    <xsl:value-of select="concat($formulafolder, translate(./@src,$uc,$lc),'.gif')"/>
	</xsl:when>
  <xsl:otherwise>
		<xsl:value-of select="concat($formulafolder, substring-before(translate(./@src,$uc,$lc),'.bmp'),'.gif')"/>
	</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
		<img src="{$img}"/>
	-->
	<!-- 20060210 TA added { -->
		<xsl:variable name="img">
			<xsl:choose>
				<xsl:when test="substring-before(@src,'.gif') != ''">
					<xsl:value-of select="concat(substring-before(translate(./@src,$uc,$lc),'.gif'),'.gif')"/>
				</xsl:when>
				<xsl:when test="substring-before(@src,'.') = ''">
					<xsl:value-of select="concat(translate(./@src,$uc,$lc),'.gif')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat(substring-before(translate(./@src,$uc,$lc),'.bmp'),'.gif')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="isBlock"><xsl:call-template name="isBlockFig"><xsl:with-param name="src" select="$img"/></xsl:call-template></xsl:variable>

		<xsl:choose>
		<xsl:when test="preceding-sibling::node() and $isBlock='true'"><br/></xsl:when>
		<xsl:otherwise><xsl:call-template name="addprespace"/></xsl:otherwise>
		</xsl:choose>
		<img src="{concat($formulafolder,$img)}" align="texttop" style="height:auto;width:auto"  />
		<xsl:choose>
		<xsl:when test="$isBlock='true'"><br/></xsl:when>
		<xsl:otherwise><xsl:call-template name="addpostspace"/></xsl:otherwise>
		</xsl:choose>
	<!-- 20060210 TA added } -->

    </xsl:template>
	<xsl:template name="nbsp" match="nbsp"><xsl:text disable-output-escaping="yes"> </xsl:text></xsl:template>
	<xsl:template name="nbsp2"><xsl:text disable-output-escaping="yes">  </xsl:text></xsl:template>
    <xsl:template match="IPCErrorListsAll">
        <html>
            <head>
                <title>IPC Error List</title>
                <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
				<script language="javascript" src="{$commonjsname}"></script>
				<script language="javascript" src="{$webservicejsname}"></script>
                <script language="Javascript" src="{$ripcisjsname}"></script>
            </head>
            <body>
                <h1>All current IPC Error List</h1>
                <table width="100%" border="0">
                    <tr>
                        <td width="10%">
							<B>Name</B>
						</td>
                        <td width="10%">
							<B>Date</B>
						</td>
                        <td width="70%">
							<B>Comment</B>
						</td>
                        <td width="10%">
							<B>Delete</B>
						</td>
                    </tr>
                    <xsl:apply-templates mode="listonly"/>
                </table>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="IPCErrorLists" mode="listonly">
        <tr>
            <td width="10%">
				<a href="javascript:viewError('{@name}')">
					<xsl:value-of select="@name"/>
				</a>
			</td>
            <td width="20%">
				<xsl:value-of select="@date"/>
			</td>
            <td width="60%">
				<xsl:choose>
					<xsl:when test="@remark and @remark!=''">
						<xsl:value-of select="@remark"/>
					</xsl:when>
					<xsl:otherwise>--no remarks--</xsl:otherwise>
				</xsl:choose>
			</td>
            <td width="10%">
				<a href="javascript:deleteErrorList('{@name}')">Delete</a>
			</td>
        </tr>
    </xsl:template>
    <xsl:template match="IPCErrorLists">
        <html>
            <head>
                <title>IPC Error List</title>
                <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
				<script language="javascript" src="{$commonjsname}"></script>
				<script language="javascript" src="{$webservicejsname}"></script>
                <script language="Javascript" src="{$ripcisjsname}"></script>
	            <script language="Javascript" src="{$popupjsname}"></script>
            </head>
            <body onload="javascript:ipcPositionSet();popupReinit()">
                <div id="overDiv" style="z-index: 1000; visibility: hidden; position: absolute; width: 96">
                </div>
                <h1>IPC Error List - <xsl:value-of select="@name"/></h1>
                <xsl:apply-templates/>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="IPCErrors">
        <table width="100%" border="0" cellpadding="0" cellspacing="1">
            <tr>
                <td width="5%" class="IPCErrors">Project</td>
                <td width="10%" class="IPCErrors">Session</td>
                <td width="15%" class="IPCErrors">Date</td>
                <td width="70%" class="IPCErrors">Remark</td>
            </tr>
            <tr>
                <td width="5%" class="IPCErrors">
					<xsl:if test="@proposalId and @projectType !=''">
						<a href="javascript:getProposal('{@projectType}','{@projectNumber}','{@proposalId}')">
							<xsl:value-of select="concat(@projectType,@projectNumber,'/',@rapporteur)"/>
						</a>
					</xsl:if>
					<xsl:call-template name="nbsp"/>
				</td>
                <td width="10%" class="IPCErrors">
					<xsl:if test="@sessionCode and @sessionCode != ''">
						<a href="javascript:getSession('{@sessionCode}','{@sessionNumber}')">
							<xsl:value-of select="concat(@sessionCode,'/',@sessionNumber)"/>
						</a>
					</xsl:if>
					<xsl:call-template name="nbsp"/>
				</td>
                <td width="15%" class="IPCErrors">
					<xsl:value-of select="@errorDate"/>
				</td>
                <td width="70%" class="IPCErrors">
					<xsl:value-of select="@remark"/>
				</td>
            </tr>
        </table>
        <table width="100%" border="0" cellpadding="0" cellspacing="1">
            <tr>
                <td class="ipcerrorshead" width="5%">#</td>
                <td class="ipcerrorshead" width="20%">Severity</td>
                <td class="ipcerrorshead" colspan="4">Text</td>
            </tr>
            <tr>
                <td class="ipcerrorshead" width="5%">
					<xsl:call-template name="nbsp"/>
				</td>
                <td class="ipcerrorshead" width="20%">IPC [- end of interval]</td>
                <td class="ipcerrorshead" width="5%">Edition / view</td>
                <td class="ipcerrorshead" width="5%">Lang.</td>
                <td class="ipcerrorshead" width="10%">Kind</td>
                <td class="ipcerrorshead">Amendment data</td>
            </tr>
            <tr>
                <td class="ipcerrorshead" width="5%">
					<xsl:call-template name="nbsp"/>
				</td>
                <td class="ipcerrorshead" width="40%" colspan="4">IPC Entry</td>
                <td class="ipcerrorshead">Amendment</td>
            </tr>
            <xsl:apply-templates/>
        </table>
        <hr/>
    </xsl:template>
    <xsl:template match="IPCError">
        <tr class="IPCError">
            <td class="IPCError" width="5%">
				<center>
					<B>
						<xsl:number count="IPCError"/>
					</B>
				</center>
			</td>
            <td class="IPCError" width="20%">
				<xsl:value-of select="@severity"/>
				<xsl:call-template name="nbsp"/>
			</td>
            <td class="IPCError" colspan="4">
				<xsl:value-of select="@text"/>
				<xsl:call-template name="nbsp"/>
			</td>
        </tr>
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="IPCErrorLocation">
        <tr class="location">
            <td width="5%">
				<xsl:call-template name="nbsp"/>
			</td>
            <td class="location" width="20%">
				<xsl:if test="@ipcEntryId">
					<a href="javascript:getEntry('{@ipcEntryId}')">
						<xsl:value-of select="@ipcSymbol"/>
					</a>
					<xsl:choose>
						<xsl:when test="@ipcEndSymbol and @ipcEndSymbol !=''">
							<br/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="nbsp"/>|<xsl:call-template name="nbsp"/></xsl:otherwise>
					</xsl:choose>
					<a href="javascript:getAllEntry('{@ipcSymbol}')">
						<xsl:call-template name="nbsp"/>
						<xsl:value-of select="@ipcSymbol"/>[all]</a>
					<xsl:if test="@ipcEndSymbol and @ipcEndSymbol !=''">- <a title="all" href="javascript:getAllEntry('{@ipcEndSymbol}')"><xsl:value-of select="@ipcEndSymbol"/> [all]</a></xsl:if>
					<!-- entryType -->
				</xsl:if>
			</td>
            <td width="5%">
				<xsl:if test="@edition and @edition != ''">
					<xsl:call-template name="getEdition"/>
				</xsl:if>
				<xsl:if test="@acceptanceLevel and @acceptanceLevel != ''">
					<xsl:value-of select="@acceptanceLevel"/>
				</xsl:if>
			</td>
            <td width="5%">
				<xsl:if test="@language and @language != ''">
					<xsl:value-of select="@language"/>
				</xsl:if>
				<xsl:call-template name="nbsp"/>
			</td>
            <td width="10%">
				<xsl:if test="@kindText and @kindText != ''">
					<xsl:value-of select="@kindText"/>
				</xsl:if>
				<xsl:call-template name="nbsp"/>
			</td>
            <td>
				<xsl:if test="@sessionCode and @sessionCode != '' and @sessionNumber and @sessionNumber != ''">
					<a href="javascript:getSession('{@sessionCode}','{@sessionNumber}','{@ipcSymbol}')">
						<xsl:value-of select="concat(@sessionCode,'/',@sessionNumber)"/>
					</a>
				</xsl:if>
				<xsl:call-template name="nbsp"/>
				<xsl:if test="@projectType and @projectType != '' and @projectNumber and @projectNumber != ''">
					<a href="javascript:getProject('{@projectType}','{@projectNumber}','{@ipcSymbol}')">
						<xsl:value-of select="concat(@projectType,'/',@projectNumber)"/>
					</a>
				</xsl:if>
				<br/>
				<xsl:if test="@amendmentId and @amendmentId != ''">
					<a href="javascript:getAmendment('{@amendmentId}')">Amendment: <xsl:value-of select="@amendmentTypeText"/></a>
				</xsl:if>
			</td>
        </tr>
        <xsl:if test="./.">
            <xsl:choose>
                <xsl:when test="amendment and ipcEntry">
                    <tr>
                        <td width="5%">
							<xsl:call-template name="nbsp"/>
						</td>
                        <td width="40%" colspan="4">
							<xsl:apply-templates select="ipcEntry" mode="dump"/>
							<xsl:call-template name="nbsp"/>
						</td>
                        <td width="55%" style="border-left:solid thin black">
							<xsl:apply-templates select="amendment" mode="dump"/>
						</td>
                    </tr>
                </xsl:when>
                <xsl:when test="amendment">
                    <tr>
                        <td width="5%">
							<xsl:call-template name="nbsp"/>
						</td>
                        <td colspan="5">
							<xsl:apply-templates select="amendment" mode="dump"/>
							<xsl:call-template name="nbsp"/>
						</td>
                    </tr>
                </xsl:when>
                <xsl:otherwise>
                    <tr>
                        <td width="5%">
							<xsl:call-template name="nbsp"/>
						</td>
                        <td colspan="5">
							<xsl:apply-templates select="ipcEntry" mode="dump"/>
							<xsl:call-template name="nbsp"/>
						</td>
                    </tr>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template match="u">
        <!-- <xsl:text> </xsl:text> -->
		<xsl:call-template name="addprespace"/>
        <u>
            <xsl:apply-templates/>
        </u>
        <!-- <xsl:text> </xsl:text> -->
    </xsl:template>
<!--    <xsl:template match="dbond"><FONT style="font-family:Symbol">=</FONT></xsl:template>
    <xsl:template match="degree">&#176;</xsl:template>
    <xsl:template match="regist">&#174;</xsl:template>
    <xsl:template match="llinkt"><SPAN style="font-family:Symbol">&#241;</SPAN></xsl:template>
    <xsl:template match="rlinkt"><SPAN style="font-family:Symbol">&#225;</SPAN></xsl:template>
    <xsl:template match="emdash">&#8212;</xsl:template>
    <xsl:template match="endash">&#8211;</xsl:template>
    <xsl:template match="larrow"><SPAN style="font-family:Symbol">&#172;</SPAN></xsl:template>
    <xsl:template match="rarrow"><SPAN style="font-family:Symbol">&#174;</SPAN></xsl:template>
    <xsl:template match="tbond"><SPAN style="font-family:Symbol">&#186;</SPAN></xsl:template>
    <xsl:template match="llinkthree"><IMG src="{$admingiffolder}/lh3bond.gif"/></xsl:template>
    <xsl:template match="rlinkthree"><IMG src="{$admingiffolder}/rh3bond.gif"/></xsl:template>
    <xsl:template match="alpha"><SPAN style="font-family:Symbol">a</SPAN></xsl:template>
    <xsl:template match="beta"><SPAN style="font-family:Symbol">b</SPAN></xsl:template>
    <xsl:template match="symbol"><SPAN style="font-family:Symbol"><xsl:value-of select="character"/></SPAN></xsl:template>
    <xsl:template match="lt">&lt;</xsl:template>
    <xsl:template match="gt"><xsl:text disable-output-escaping="yes">&amp;</xsl:text>gt;</xsl:template>
    <xsl:template match="le"><SPAN style="font-family:Symbol">&#163;</SPAN></xsl:template>
    <xsl:template match="ge"><SPAN style="font-family:Symbol">&#179;</SPAN></xsl:template>
    <xsl:template match="omega"><SPAN style="font-family:Symbol">W</SPAN></xsl:template>-->
	<xsl:template match="dbond">
		<font face="Symbol">=</font>
	</xsl:template>
	<xsl:template match="degree">&#xB0;</xsl:template>
	<xsl:template match="regist">&#xAE;</xsl:template>
	<xsl:template match="llinkt"><img src="img/llinkt.gif" align="texttop"/></xsl:template>
	<xsl:template match="rlinkt"><img src="img/rlinkt.gif" align="texttop"/></xsl:template>
	<xsl:template match="emdash">&#x2014;</xsl:template>
	<xsl:template match="endash">&#x2013;</xsl:template>
	<xsl:template match="larrow"><img src="img/larrow.gif" align="texttop"/></xsl:template>
	<xsl:template match="rarrow"><img src="img/rarrow.gif" align="texttop"/></xsl:template>
	<xsl:template match="tbond"><img src="img/tbond.gif" align="texttop"/></xsl:template>
	<xsl:template match="llinkthree">
		<IMG src="img/lh3bond.gif" align="absmiddle"/>
	</xsl:template>
	<xsl:template match="rlinkthree">
		<IMG src="img/rh3bond.gif" align="absmiddle"/>
	</xsl:template>
	<xsl:template match="alpha">
		<SPAN style="font-family:Symbol">a</SPAN>
	</xsl:template>
	<xsl:template match="beta"><xsl:call-template name="addprespace"/><img src="img/beta.gif" align="texttop"/></xsl:template>
	<xsl:template match="symbol">
		<SPAN style="font-family:Symbol">
			<xsl:value-of select="character"/>
		</SPAN>
	</xsl:template>
	<xsl:template match="lt">&lt;</xsl:template>
	<xsl:template match="gt">
		<xsl:text disable-output-escaping="yes">&amp;</xsl:text>gt;</xsl:template>
	<xsl:template match="le">
		<SPAN style="font-family:Symbol">&#xA3;</SPAN>
	</xsl:template>
	<xsl:template match="ge">
		<SPAN style="font-family:Symbol">&#xB3;</SPAN>
	</xsl:template>
	<xsl:template match="omega"><img src="img/omega.gif" align="texttop"/></xsl:template>
    
    <xsl:template match="ipcEntry" mode="dump">
        <xsl:choose>
            <xsl:when test="count(.//*) &gt; 10">
                <table width="100%">
                    <tr>
                        <td>
							<xsl:apply-templates select="."/>
						</td>
                    </tr>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="resource">
                    <xsl:with-param name="depth">1</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="amendment" mode="dump">
        <xsl:choose>
            <xsl:when test="count(.//*) &gt; 10">
                <!--<table width="100%" border="0">-->
                    <xsl:apply-templates select="."/>
                <!--</table>-->
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="resource">
                    <xsl:with-param name="depth">1</xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- Library -->
    <xsl:template name="resource">
        <xsl:param name="depth"/>
        <xsl:choose>
            <xsl:when test="text()">
                <!-- inline because of any text node -->
                <p class="hidden">
                    <table cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td width="{3 * $depth}%">
								<xsl:call-template name="nbsp"/>
							</td>
                            <td class="dump" width="{100 - 3*$depth}%">
								<xsl:call-template name="inline-resource"/>
							</td>
                        </tr>
                    </table>
                </p>
            </xsl:when>
            <xsl:when test="count(*|text())=0">
                <!-- single, non-text node, without children -->
                <p class="hidden">
                    <table cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td width="{3 * $depth}%">
								<xsl:call-template name="nbsp"/>
							</td>
                            <td class="dump" width="{100 - 3*$depth}%">
								<span class="open">
									<xsl:call-template name="name-and-attributes"/>/&gt;</span>
								<BR/>
							</td>
                        </tr>
                    </table>
                </p>
            </xsl:when>
            <xsl:when test="count(*)=1 and not(*/text()) and not(*/@*)">
                <p class="hidden">
                    <table cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td width="{3 * $depth}%">
								<xsl:call-template name="nbsp"/>
							</td>
                            <td class="dump" width="{100 - 3*$depth}%">
								<xsl:call-template name="name-and-attributes"/>
								<span class="open">&gt;</span>
								<xsl:for-each select="*">
									<xsl:call-template name="name-and-attributes"/>
									<span class="open">&gt;</span>
								</xsl:for-each>
							</td>
                        </tr>
                    </table>
                </p>
                <xsl:for-each select="*/*">
                    <xsl:call-template name="resource">
                        <xsl:with-param name="depth" select="$depth + 1"/>
                    </xsl:call-template>
                </xsl:for-each>
                <p class="hidden">
                    <table cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td width="{3 * $depth}%">
								<xsl:call-template name="nbsp"/>
							</td>
                            <td class="dump" width="{100 - 3*$depth}%">
								<xsl:for-each select="*">
									<span class="close">&lt;/<xsl:value-of select="name()"/>&gt;</span>
								</xsl:for-each>
								<span class="close">&lt;/<xsl:value-of select="name()"/>&gt;</span>
							</td>
                        </tr>
                    </table>
                </p>
            </xsl:when>
            <xsl:when test="count(*)=1 and */text() and not(*/*) and not(*/@*)">
                <p class="hidden">
                    <table cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td width="{3 * $depth}%">
								<xsl:call-template name="nbsp"/>
							</td>
                            <td class="dump" width="{100 - 3*$depth}%">
								<xsl:call-template name="name-and-attributes"/>
								<span class="open">&gt;</span>
								<xsl:for-each select="*">
									<xsl:call-template name="name-and-attributes"/>
									<span class="open">&gt;</span>
								</xsl:for-each>
								<span class="text">
									<xsl:value-of select="*/text()"/>
								</span>
								<xsl:for-each select="*">
									<span class="close">&lt;/<xsl:value-of select="name()"/>&gt;</span>
								</xsl:for-each>
								<span class="close">&lt;/<xsl:value-of select="name()"/>&gt;</span>
							</td>
                        </tr>
                    </table>
                </p>
            </xsl:when>
            <xsl:otherwise>
                <p class="hidden">
                    <table cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td width="{3 * $depth}%">
								<xsl:call-template name="nbsp"/>
							</td>
                            <td class="dump" width="{100 - 3*$depth}%">
								<xsl:call-template name="name-and-attributes"/>
								<span class="open">&gt;</span>
							</td>
                        </tr>
                    </table>
                </p>
                <xsl:for-each select="*">
                    <xsl:call-template name="resource">
                        <xsl:with-param name="depth" select="$depth + 1"/>
                    </xsl:call-template>
                </xsl:for-each>
                <p class="hidden">
                    <table cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <td width="{3 * $depth}%">
								<xsl:call-template name="nbsp"/>
							</td>
                            <td class="dump" width="{100 - 3*$depth}%">
								<span class="close">&lt;/<xsl:value-of select="name()"/>&gt;</span>
							</td>
                        </tr>
                    </table>
                </p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="inline-resource">
        <xsl:choose>
            <xsl:when test="name()=''">
                <span class="text">
                    <xsl:value-of select="."/>
                </span>
            </xsl:when>
            <xsl:when test="count(*|text())=0">
                <span class="open">
                    <xsl:call-template name="name-and-attributes"/>/&gt;</span>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="name-and-attributes"/>
                <span class="open">&gt;</span>
                <xsl:for-each select="*|text()">
                    <xsl:choose>
                        <xsl:when test="name()=''">
                            <span class="text">
                                <xsl:value-of select="."/>
                            </span>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:call-template name="inline-resource"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
                <span class="close">&lt;/<xsl:value-of select="name()"/>&gt;</span>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="name-and-attributes">
        <span class="open">&lt;<xsl:value-of select="name()"/></span>
        <xsl:for-each select="@*">
            <xsl:sort select="name()"/>
            <xsl:text> </xsl:text>
            <span class="attribute">
                <xsl:value-of select="name()"/>
            </span>=<span class="value"><xsl:value-of select="concat('&quot;',., '&quot;')"/></span></xsl:for-each>
    </xsl:template>
    <xsl:template name="cr" match="cr">
        <br/>
    </xsl:template>
    <xsl:template name="rawtext">
        <xsl:apply-templates select="./text//text()"/>
    </xsl:template>
    <xsl:template name="dumpSymbolInterval">
        <xsl:call-template name="ref">
            <xsl:with-param name="ref" select="@symbol"/>
        </xsl:call-template>
        <xsl:if test="@endSymbol and @endSymbol != ''">
            <xsl:call-template name="nbsp"/>-<xsl:call-template name="nbsp"/>
            <br/>
            <xsl:call-template name="ref">
                <xsl:with-param name="ref" select="@endSymbol"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    <xsl:template name="dumpSymbol">
        <xsl:param name="symbol"/>
        <xsl:value-of select="substring($symbol,1,4)"/>
        <xsl:if test="string-length($symbol) &gt; 4">
            <xsl:call-template name="nbsp"/>
            <xsl:value-of select="concat(number(substring($symbol,5,3)),'/',substring($symbol,8,string-length($symbol)))"/>
        </xsl:if>
    </xsl:template>
    <xsl:template match="hl">
        <span class="marked">
            <xsl:apply-templates/>
        </span>
        <xsl:text> </xsl:text>
    </xsl:template>
  <xsl:template match="oe"><xsl:text disable-output-escaping="yes">&amp;</xsl:text>#156;</xsl:template>
    <xsl:template match="OE"><xsl:text disable-output-escaping="yes">&amp;</xsl:text>#140;</xsl:template>
    <xsl:template match="illustrations"><br/>
	<table width="100%"><tr><td>
	<xsl:apply-templates select="illustration"/>
	</td></tr></table>
    </xsl:template>
    <xsl:template match="illustration">
		<img onmouseover="javascript:showIPCImageDiv('{@src}');" onmouseout="javascript:hideIPCImageDiv();" src="{@src}"/><xsl:text> </xsl:text><xsl:call-template name="nbsp"/>
	</xsl:template>


	<xsl:template name="addprespace">
		<xsl:variable name="prev" select="name(preceding-sibling::node()[1])"/>
		<!--
		<xsl:variable name="prev" select="name(preceding-sibling::*[1]|preceding-sibling::text()[last()])"/>
		-->
<!--		<xsl:variable name="prev" select="name($prevnode[last()])"/>

			[<xsl:value-of select="position()"/>]
		[<xsl:value-of select="name(preceding-sibling::node()[1])"/>] -->
		<xsl:choose>
			<xsl:when test="$prev='#text'or $prev=''">
				<xsl:variable name="text" select="preceding-sibling::text()[1]"/>
				<xsl:variable name="lastchar" select="substring($text, string-length($text), 1)"/>
				<xsl:if test="$lastchar != '' and $lastchar != ' ' and $lastchar != '&quot;' and $lastchar != '('"><xsl:call-template name="nbsp"/></xsl:if>
			</xsl:when>
			<xsl:when test="$prev='u' or $prev='sref' or $prev='mref' or $prev='GREF'">
				<xsl:call-template name="nbsp"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="addpostspace">
		<xsl:variable name="next" select="name(following-sibling::node()[1])"/>
		<!--
		<xsl:variable name="prev" select="name(preceding-sibling::*[1]|preceding-sibling::text()[last()])"/>
		-->
<!--		<xsl:variable name="prev" select="name($prevnode[last()])"/>

			[<xsl:value-of select="position()"/>]
		[<xsl:value-of select="name(preceding-sibling::node()[1])"/>] -->

		<xsl:choose>
			<xsl:when test="$next='#text'or $next=''">
				<xsl:variable name="text" select="following-sibling::text()[1]"/>
				<xsl:variable name="firstchar" select="substring($text, 1, 1)"/>
<!--				[<xsl:value-of select="$firstchar"/>]-->
				<xsl:if test="$firstchar !='' and $firstchar != ')' and $firstchar != '.' and $firstchar != ':' and $firstchar != ' ' and $firstchar != ',' and $firstchar != ';' and $firstchar != '&quot;'"><xsl:call-template name="nbsp"/></xsl:if>
			</xsl:when>
			<xsl:when test="$next='u' or $next='sref' or $next='mref'">
				<xsl:call-template name="nbsp"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="langjump">
		<xsl:param name="languages"/>
		<xsl:if test="string-length($languages) >= 4">
			<xsl:variable name="ol" select="translate(substring($languages,2,2),$uc,$lc)"/>
			<xsl:if test="$ol != translate(@lang,$uc,$lc)">
				<xsl:variable name="OL" select="translate($ol,$lc,$uc)"/>
				<A href="javascript:jumpLang('{$OL}','{@symbol}','{@endSymbol}')"><img border="0" src="{concat($admingiffolder,$ol,'.gif')}"/></A>
			</xsl:if>
			<xsl:call-template name="langjump"><xsl:with-param name="languages" select="substring($languages,4)"/></xsl:call-template>
		</xsl:if>
	</xsl:template>


	<xsl:template name="mergeedition">
		<xsl:param name="edition"/>
		<xsl:variable name="ed">
			<xsl:choose>
				<xsl:when test="contains($edition, ',')">
					<xsl:value-of select="substring-before($edition,',')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$edition"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$ed='19680901'">1</xsl:when>
			<xsl:when test="$ed='19740701'">2</xsl:when>
			<xsl:when test="$ed='19800101'">3</xsl:when>
			<xsl:when test="$ed='19850101'">4</xsl:when>
			<xsl:when test="$ed='19900101'">5</xsl:when>
			<xsl:when test="$ed='19950101'">6</xsl:when>
			<xsl:when test="$ed='20000101'">7</xsl:when>
			<xsl:when test="$ed='20060101'">8</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($ed,1,4),'.',substring($ed,5,2))"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="contains($edition, ',')">
			<xsl:text>,</xsl:text>
			<xsl:call-template name="mergeedition"><xsl:with-param name="edition" select="substring-after($edition,',')"/></xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getEdition">
		<xsl:call-template name="mergeedition"><xsl:with-param name="edition" select="@edition"/></xsl:call-template>
	</xsl:template>

</xsl:stylesheet>





<!-- Stylus Studio meta-information - (c) 2004-2005. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="..\scratch\class&#x2D;es&#x2D;advanced\xml\A61.xml" htmlbaseurl="" outputurl="" processortype="msxml4" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition></MapperMetaTag>
</metaInformation>
--><!-- Stylus Studio meta-information - (c) 2004-2005. Progress Software Corporation. All rights reserved.
<metaInformation>
<scenarios/><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition></MapperMetaTag>
</metaInformation>
--><!-- Stylus Studio meta-information - (c)1998-2004. Sonic Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="..\..\..\data.xml" htmlbaseurl="" outputurl="" processortype="internal" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition></MapperMetaTag>
</metaInformation>
-->