<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:variable name="lang" select="flatNotes/@lang"/>
	<xsl:variable name="wordsFile" select="document('wordsFile.xml')"/>
	<xsl:variable name="indentChanged1">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'indentChanged1'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="indentChanged2">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'indentChanged2'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="subclassIndex">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'subclassIndex'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="deletedText1">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'deletedText1'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="deletedText2">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'deletedText2'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="deletedText3">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'deletedText3'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="movedText1">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'movedText1'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="movedText2">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'movedText2'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="modifiedText1">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'modifiedText1'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="movemodifiedText1">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'movemodifiedText1'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="movemodifiedText2">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'movemodifiedText2'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="lines">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'lines'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="lessEE">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'lessEE'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="EEgreater">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'EEgreater'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="dashText">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'dashText'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="listTypeChanged1">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'listTypeChanged1'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="listTypeChanged2">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'listTypeChanged2'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>
	<xsl:variable name="listTypeChanged3">
		<xsl:call-template name="getWordsFromFile">
			<xsl:with-param name="id" select="'listTypeChanged3'"></xsl:with-param>
		</xsl:call-template>
	</xsl:variable>

	<xsl:variable name="compact">
    <xsl:choose>
    <xsl:when test="//flatNotes/@mode='full'">full</xsl:when>
    <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>


	<xsl:template match="flatNotes">
	<xsl:variable name="noteorindex">
		<xsl:value-of select="./@type"/>
	</xsl:variable>
				<xsl:choose>
					<xsl:when test="$noteorindex='index'">
						<table width="100%" border="0" cellpadding="0" cellspacing="0">
							<TR>
								<TD class="index">
									<xsl:value-of select="$subclassIndex"/>
								</TD>
							</TR>
							<TR>

								<TD>
									<TABLE width="100%" cellpadding="0" cellspacing="0">
										<xsl:call-template name="flatindex"/>
									</TABLE>
								</TD>
							</TR>
						</table>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates/>
					</xsl:otherwise>
				</xsl:choose>
	</xsl:template>

	<xsl:template name="myFlatNote">
		<xsl:param name="outtype"/>
		<xsl:variable name="noteorindex" select="ancestor::flatNotes/@type"/>
		<xsl:variable name="type" select="./@type"/>
		<xsl:variable name="num">
		<xsl:choose>
		<xsl:when test="./@newnum">			<!-- MATE: newnum?! -->
		 <xsl:value-of select="./@newnum"/> <!-- MATE: newnum?! -->
		</xsl:when>
		<xsl:otherwise>
		<xsl:value-of select="./@num"/>
		</xsl:otherwise>
		</xsl:choose>
		</xsl:variable>
		<xsl:variable name="myid" select="./@myid"/>
		<xsl:variable name="isOrphan">
			<xsl:choose>
				<xsl:when test="@Orphan='1'">
					<xsl:value-of select="number(./@indent)-1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./@indent"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="indent">
			<xsl:choose>
				<xsl:when test="@type='none' and number($isOrphan)>0">
					<xsl:value-of select="number($isOrphan)-1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$isOrphan"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="pclass">
			<xsl:if test="@type='table'">table</xsl:if>
			<xsl:if test="$noteorindex='index'">index</xsl:if>
			<xsl:value-of select="concat('flatp',$indent)"/>
			<xsl:choose>
			<xsl:when test="@notetype='deleted'">-d</xsl:when>
			<xsl:when test="@notetype='new'">-n</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="bclass">
			<xsl:choose>
			<xsl:when test="@notetype='deleted'">deleted</xsl:when>
			<xsl:when test="@notetype='new'">new</xsl:when>

			</xsl:choose>
		</xsl:variable>
			<xsl:choose>
				<xsl:when test="$outtype='deleted'">
					<p class="{$pclass}">
					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
					</p>
				</xsl:when>
				<xsl:when test="$type='bullet'">
					<table>
					<tr>

					<td class="b{$pclass}">&#x2022;</td>
					<td class="{$bclass}">
					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
					</td>
					</tr>
					</table>
				</xsl:when>
				<xsl:when test="./@listtypechangedto='number' or $type='number' or $type='Number'">
					<table>
					<tr>

					<td class="{$pclass}">
						<xsl:value-of select="$num"/>.</td>
					<td class="{$bclass}">
					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
					</td>
					</tr>

					</table>
				</xsl:when>
				<xsl:when test="./@listtypechangedto='roman' or $type='roman'">
					<table>
					<tr>

					<td class="{$pclass}">
						<xsl:number format="i" level="single" count="flatNote[@myid=$myid]"/>.</td>
					<td  class="{$bclass}">
					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
					</td>
					</tr>
					</table>
				</xsl:when>
				<xsl:when test="./@listtypechangedto='Roman' or $type='Roman'">
					<table>
					<tr>
					<td class="{$pclass}">
						<xsl:number format="I" level="single" count="flatNote[@myid=$myid]"/>.
					</td>
					<td class="{$bclass}">
					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
					</td>
					</tr>
					</table>
				</xsl:when>
				<xsl:when test="./@listtypechangedto='alpha' or $type='alpha'">
					<table>
					<tr>

					<td class="{$pclass}">
						<xsl:number format="a" level="single" count="flatNote[@myid=$myid]"/>.</td>
					<td class="{$bclass}">
					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
					</td>
					</tr>
					</table>
				</xsl:when>
				<xsl:when test="./@listtypechangedto='Alpha' or $type='Alpha'">
					<table>
					<tr>
					<td class="{$pclass}">
						<xsl:number format="A" level="single" count="flatNote[@myid=$myid]"/>.</td>
					<td class="body">

					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
					</td>
					</tr>
					</table>
				</xsl:when>
				<xsl:when test="$type='table'">
					<table>
					<tr>

					<td class="{$pclass}">

						<xsl:apply-templates select="references"/>
					</td>
					<td class="{$bclass}">
					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
					</td>
					</tr>
					</table>
				</xsl:when>
				<xsl:otherwise>
				<!--
					<table>
					<tr>
					<td class="{$pclass}"><xsl:call-template name="mynbsp"/></td>
					<td class="{$bclass}">
				-->
					<xsl:call-template name="writeOut">
						<xsl:with-param name="outtype" select="$outtype"/>
					</xsl:call-template>
				<!--
					</td>
					</tr>
					</table>
				-->
				</xsl:otherwise>
			</xsl:choose>
	</xsl:template>

	<xsl:template name="writeOut">
		<xsl:param name="outtype"/>
		<xsl:choose>
			<xsl:when test="$outtype='deleted'">
				<xsl:call-template name="deletedText"/>
			</xsl:when>
			<xsl:when test="$outtype='Note '">
				<span class="compact">
					<xsl:value-of select="$movedText1"/>
					<xsl:value-of select="@to"/>
					<xsl:value-of select="$movedText2"/>
					<BR/>
				</span>
			</xsl:when>
			<xsl:when test="$outtype='full'">
				<xsl:choose>
					<xsl:when test="$compact!='full' and (./@notetype='modified' or ./@notetype='movemodified')">
						<xsl:apply-templates select="text" mode="dash"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$outtype='first'">
				<xsl:for-each select=".//first3Word">
					<xsl:call-template name="first3Word"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$outtype='last'">
				<xsl:for-each select=".//last3Word">
					<xsl:call-template name="last3Word"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$outtype='firstlast'">
				<xsl:for-each select=".//first3Word">
					<xsl:call-template name="first3Word"/>
				</xsl:for-each>
				<xsl:for-each select=".//last3Word">
					<xsl:call-template name="last3Word"/>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$outtype='first1last1'">
				<xsl:for-each select=".//firstWord">
					<xsl:call-template name="firstWord"/>
				</xsl:for-each>
				<xsl:for-each select=".//lastWord">
					<xsl:call-template name="lastWord"/>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>

	</xsl:template>

	<xsl:template name="flatindex">
		<xsl:for-each select=".//flatNote">
			<xsl:if test="./@myid='text'">
				<TR>
					<xsl:call-template name="indexEntryflat"/>
				</TR>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="indexEntryflat">
		<xsl:call-template name="indexEntryflati"/>
		<xsl:for-each select="following-sibling::flatNote[1]">
			<xsl:call-template name="indexEntryflatr"/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="indexEntryflati">
		<xsl:if test="./@myid='text'">
			<xsl:variable name="d" select="./@indent"/>
			<TD style="padding-left:{$d*20}px" width="70%">
				<xsl:apply-templates select="." mode="index"/>
			</TD>
		</xsl:if>
	</xsl:template>

	<xsl:template name="indexEntryflatr">
		<xsl:if test="./@myid='references'">
			<TD>
				<xsl:apply-templates select="." mode="index"/>
			</TD>
		</xsl:if>
	</xsl:template>

	<xsl:template name="myIndexEntry">
		<xsl:param name="outtype"/>
		<xsl:call-template name="writeOut">
			<xsl:with-param name="outtype" select="$outtype"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="flatNote" mode="index">
		<xsl:choose>
			<xsl:when test="$compact='full'">
				<xsl:call-template name="fullIndexEntry"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="compactIndexEntry"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="flatNote">
		<xsl:choose>
			<xsl:when test="$compact='full'">
				<xsl:call-template name="fullFlatNote"/>
			</xsl:when>

			<xsl:otherwise>
			<!--	<xsl:call-template name="compactFlatNote"/>-->
				<xsl:call-template name="testFlatNote"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="compactFlatNote">
		<xsl:choose>
			<xsl:when test="@notetype='new'">
				<span class="textnew">
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:when test="@notetype='deleted'">
				<xsl:call-template name="deletedText"/>
			</xsl:when>
			<xsl:when test="@listtypechangedfrom and @listtypechangedto">
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'first1last1'"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="@notetype='moved'">
				<xsl:value-of select="$movedText1"/>
				<xsl:value-of select="@to"/>
				<xsl:value-of select="$movedText2"/>
				<BR/>
			</xsl:when>
			<xsl:when test="@notetype='modified'">
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'full'"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="@notetype='movemodified'">
				<xsl:value-of select="$movemodifiedText1"/>
				<xsl:value-of select="@to"/>
				<xsl:value-of select="movemodifiedText2"/>
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'full'"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="preceding-sibling::flatNote[1]/@notetype and following-sibling::flatNote[1]/@notetype  and number(following-sibling::flatNote[1]/@indent)=number(@indent)  and number(preceding-sibling::flatNote[1]/@indent)=number(@indent)">
						<xsl:value-of select="$lessEE"/>
						<BR/>
						<xsl:call-template name="myFlatNote">
							<xsl:with-param name="outtype" select="'firstlast'"/>
						</xsl:call-template>
						<BR/>
						<xsl:value-of select="$EEgreater"/>
					</xsl:when>
					<xsl:when test="preceding-sibling::flatNote[1]/@notetype and number(preceding-sibling::flatNote[1]/@indent)=number(@indent)">
						<xsl:value-of select="$lessEE"/>
						<BR/>
						<xsl:call-template name="myFlatNote">
							<xsl:with-param name="outtype" select="'first'"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="following-sibling::flatNote[1]/@notetype and number(following-sibling::flatNote[1]/@indent)=number(@indent)">
						<xsl:call-template name="myFlatNote">
							<xsl:with-param name="outtype" select="'last'"/>
						</xsl:call-template>
						<xsl:value-of select="$EEgreater"/>
						<BR/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="hasChildModified"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="hasChildModified">
		<xsl:variable name="myid">
			<xsl:value-of select="@myid"/>
			<xsl:value-of select="@num"/>
			<xsl:value-of select="@type"/>.</xsl:variable>
		<xsl:variable name="wasChild">
			<xsl:for-each select="following-sibling::flatNote">
				<xsl:if test="@notetype and starts-with(@myid,$myid)">a</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:if test="contains($wasChild,'a')">
			<xsl:call-template name="myFlatNote">
				<xsl:with-param name="outtype" select="'first'"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="deletedText">
		<span class="compact">
		<xsl:choose>
			<xsl:when test="@indent='0'">
				<xsl:value-of select="$deletedText1"/>
				<xsl:value-of select="@num"/>
				<xsl:value-of select="$deletedText2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$deletedText3"/>
			</xsl:otherwise>
		</xsl:choose>
		</span>
		<BR/>
	</xsl:template>

	<xsl:template name="compactIndexEntry">
		<xsl:choose>
			<xsl:when test="@myid='references'">
				<xsl:choose>
					<xsl:when test="preceding-sibling::flatNote[1]/@notetype='new'">
						<span class="textnew">
							<xsl:call-template name="myIndexEntry">
								<xsl:with-param name="outtype" select="'full'"/>
							</xsl:call-template>
						</span>
					</xsl:when>
					<xsl:when test="preceding-sibling::flatNote[1]/@notetype='modified'">
						<xsl:call-template name="myIndexEntry">
							<xsl:with-param name="outtype" select="'full'"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="preceding-sibling::flatNote[1]/@notetype='movemodified'">
						<xsl:call-template name="myIndexEntry">
							<xsl:with-param name="outtype" select="'full'"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="@myid='text'">
				<xsl:choose>
					<xsl:when test="@notetype='new'">
						<span class="textnew">
							<xsl:call-template name="myIndexEntry">
								<xsl:with-param name="outtype" select="'full'"/>
							</xsl:call-template>
						</span>
					</xsl:when>
					<xsl:when test="@notetype='deleted'">
						<span class="textdel">
							<xsl:call-template name="myIndexEntry">
								<xsl:with-param name="outtype" select="'full'"/>
							</xsl:call-template>
						</span>
					</xsl:when>
					<xsl:when test="@notetype='moved'">
						<xsl:value-of select="$movedText1"/>
						<xsl:value-of select="@to"/>
						<xsl:value-of select="$movedText2"/>
						<xsl:call-template name="changeIndent"/>
						<BR/>
					</xsl:when>
					<xsl:when test="@notetype='modified'">
						<xsl:call-template name="changeIndent"/>
						<xsl:call-template name="myIndexEntry">
							<xsl:with-param name="outtype" select="'full'"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="@notetype='movemodified'">
						<xsl:value-of select="$movemodifiedText1"/>
						<xsl:value-of select="@to"/>
						<xsl:value-of select="$movemodifiedText2"/>
						<xsl:call-template name="changeIndent"/>
						<BR/>
						<xsl:call-template name="myIndexEntry">
							<xsl:with-param name="outtype" select="'full'"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="changeIndent"/>
						<xsl:if test="preceding-sibling::flatNote[2]/@notetype">
							<BR/>
							<span class="onLeftMargin">
								<xsl:value-of select="$lessEE"/>
							</span>
							<BR/>
							<xsl:call-template name="myIndexEntry">
								<xsl:with-param name="outtype" select="'first'"/>
							</xsl:call-template>
						</xsl:if>
						<xsl:if test="following-sibling::flatNote[2]/@notetype">
							<xsl:call-template name="myIndexEntry">
								<xsl:with-param name="outtype" select="'last'"/>
							</xsl:call-template>
							<BR/>
							<span class="onLeftMargin">
								<xsl:value-of select="$EEgreater"/>
							</span>
							<BR/>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="changeIndent">
		<xsl:if test="@indentChange">
			<xsl:value-of select="$indentChanged1"/>
			<xsl:value-of select="@indentChange"/>
			<xsl:value-of select="$indentChanged2"/>
			<BR/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="last3Word">
		<xsl:value-of select="$dashText"/>
		<xsl:apply-templates select="following-sibling::text()|following-sibling::*"/>
	</xsl:template>

	<xsl:template name="first3Word">
		<xsl:apply-templates select="preceding-sibling::text()|preceding-sibling::*"/>
		<xsl:value-of select="$dashText"/>
	</xsl:template>

	<xsl:template name="lastWord">
		<xsl:value-of select="$dashText"/>
		<xsl:apply-templates select="following-sibling::text()|following-sibling::*"/>
	</xsl:template>

	<xsl:template name="firstWord">
		<xsl:apply-templates select="preceding-sibling::text()|preceding-sibling::*"/>
		<xsl:value-of select="$dashText"/>
	</xsl:template>

	<xsl:template name="fullFlatNote">
		<xsl:if test="@listtypechangedfrom and @listtypechangedto">
			<xsl:value-of select="$listTypeChanged1"/>
			<!--	<xsl:value-of select="@listtypechangedfrom"/>-->
			<xsl:value-of select="$listTypeChanged2"/>
			<!--<xsl:value-of select="@listtypechangedto"/>-->
			<xsl:value-of select="$listTypeChanged3"/>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="@notetype='new'">
				<span class="textnew">
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
				<xsl:if test="following-sibling::flatNote"><br/></xsl:if>
			</xsl:when>
			<xsl:when test="@notetype='deleted'">
				<span class="textdel">
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
				<!-- <xsl:if test="following-sibling::flatNote"><br/></xsl:if> -->
			</xsl:when>
			<xsl:when test="@notetype='moved'">
				<!-- <span class="textmoved"> -->
				<!--	<xsl:value-of select="$movedText1"/>
					<xsl:value-of select="@to"/>
					<xsl:value-of select="$movedText2"/>-->
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				<!-- </span> -->
			</xsl:when>
			<xsl:when test="@notetype='modified'">
				<span class="textmoved">
					<xsl:value-of select="$modifiedText1"/>
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:when test="@notetype='movemodified'">
				<span class="textmoved">
					<!--<xsl:value-of select="$movemodifiedText1"/>
					<xsl:value-of select="@to"/>
					<xsl:value-of select="$movemodifiedText1"/>-->
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'full'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="testFlatNote">
			<!--	<xsl:if test="@outTypeModeo='1'">
					<xsl:value-of select="$lessEE"/><BR/>
				</xsl:if>-->
		<xsl:choose>
			<xsl:when test="@notetype='new'">
				<span class="textnew">
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:when test="@notetype='deleted'">
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'deleted'"/>
					</xsl:call-template>
			</xsl:when>
			<xsl:when test="@listtypechangedfrom and @listtypechangedto">
				<span class="textmoved">
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'first1last1'"/>
					</xsl:call-template>

				</span>
			</xsl:when>
			<xsl:when test="@notetype='moved'">
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'Note '"/>
				</xsl:call-template>

			</xsl:when>
			<xsl:when test="@notetype='modified'">
				<span class="textmoved">
					<xsl:value-of select="$modifiedText1"/>
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:when test="@notetype='movemodified'">
				<span class="compact">

				</span>
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
					<BR/>

			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
				<xsl:when test="@outTypeKind='first1last1'">
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'first1last1'"/>
				</xsl:call-template>
				</xsl:when>
				<xsl:when test="@outTypeKind='first3'">
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'first'"/>
				</xsl:call-template>
				</xsl:when>
				<xsl:when test="@outTypeKind='last3'">
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'last'"/>
				</xsl:call-template>
				</xsl:when>
				</xsl:choose>

			</xsl:otherwise>
		</xsl:choose>
			<!--	<xsl:if test="@outTypeModec='1'">
					<xsl:value-of select="$EEgreater"/><BR/>
				</xsl:if>
				<xsl:if test="@outTypeModeLines='1'">
					<xsl:value-of select="$lines"/><BR/>
				</xsl:if>-->


	</xsl:template>


	<xsl:template name="fullIndexEntry">
		<xsl:choose>
			<xsl:when test="@notetype='new'">
				<span class="textnew">
					<xsl:call-template name="myIndexEntry">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:when test="@notetype='deleted'">
				<span class="textdel">
					<xsl:call-template name="myIndexEntry">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:when test="@notetype='moved'">
				<xsl:if test="@myid='text'">
					<xsl:call-template name="changeIndent"/>
				</xsl:if>
				<span class="textmoved">
					<xsl:value-of select="$movedText1"/>
					<xsl:value-of select="@to"/>
					<xsl:value-of select="$movedText2"/>
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:when test="@notetype='modified'">
				<xsl:if test="@myid='text'">
					<xsl:call-template name="changeIndent"/>
				</xsl:if>
				<span class="textmoved">
					<xsl:value-of select="$modifiedText1"/>
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:when test="@notetype='movemodified'">
				<xsl:if test="@myid='text'">
					<xsl:call-template name="changeIndent"/>
				</xsl:if>
				<span class="textmoved">
					<xsl:value-of select="$movemodifiedText1"/>
					<xsl:value-of select="@to"/>
					<xsl:value-of select="$movemodifiedText2"/>
					<xsl:call-template name="myFlatNote">
						<xsl:with-param name="outtype" select="'full'"/>
					</xsl:call-template>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="@myid='text'">
					<xsl:call-template name="changeIndent"/>
				</xsl:if>
				<xsl:call-template name="myFlatNote">
					<xsl:with-param name="outtype" select="'full'"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template match="textnew">
		<span class="textnew">
			<xsl:apply-templates/>
		</span>
	</xsl:template>

	<xsl:template match="textdel">
		<span class="textdel">
			<xsl:apply-templates/>
		</span>
	</xsl:template>

	<xsl:template name="getWordsFromFile">
		<xsl:param name="id"/>
		<xsl:choose>
		<xsl:when test="$lang='FR'">
			<xsl:value-of select="$wordsFile/words/word[@id=$id]/f"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$wordsFile/words/word[@id=$id]/e"/>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="mynbsp">
		<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
	</xsl:template>

</xsl:stylesheet>

<!-- Stylus Studio meta-information - (c)1998-2004. Sonic Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Test" userelativepaths="yes" externalpreview="no" url="file:///c:/temp/test.xml" htmlbaseurl="" outputurl="file:///c:/temp/test.htm" processortype="internal" profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition></MapperMetaTag>
</metaInformation>
-->