<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:import href="common.xsl"/>

	<xsl:output method="html" indent="no" encoding="unicode"/>

	
	<xsl:template match="/">
		<html>
			<head>
				<link href="{$admincssname}" rel="styleSheet" type="text/css"/>
				<script language="javascript" src="{$commonjsname}"></script>
				<script language="javascript" src="{$webservicejsname}"></script>
				<SCRIPT language="Javascript" src="{$adminjsname}"></SCRIPT>
			</head>
			<body>
				<h4>Your files:</h4>
				<table border="1" style="border-collapse: collapse" cellpadding="2" cellspacing="0" width="100%">
					<tr>
						<td></td>
						<td><b>Name</b></td>
						<td><b>Size</b></td>
					</tr>
					<xsl:for-each select="files/file">
						<tr>
							<td>
								<img src="{$admingiffolder}/file.gif"/></td>
							<td>
								<a href="#" onclick="javascript:showFileData('{@name}', {@size});">
									<xsl:value-of select="substring-after(@name, '/')"/>
								</a>
							</td>
							<td>
								<xsl:value-of select="@size"/>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</body>
		</html>
	</xsl:template>

</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2003 Copyright Sonic Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="file://c:\temp\data.xml" htmlbaseurl="" outputurl="" processortype="msxml4" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
</metaInformation>
-->