<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:xutil="xutil">

	<xsl:template name="editAmendment">
		<xsl:param name="bodyonly"/>
		<xsl:choose>
			<xsl:when test="$bodyonly='1'">
				<xsl:call-template name="putHTMLText"/>
				<xsl:call-template name="htmleditor"/>
			</xsl:when>
			<xsl:otherwise >
				<HTML>
					<HEAD>
						<TITLE>RIPCIS: Editors</TITLE>
						<LINK rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
						<LINK rel="STYLESHEET" name="styles" type="text/css" href="{$admineditorcssname}"/>
						<script language="javascript" src="{$commonjsname}"></script>
						<script language="javascript" src="{$webservicejsname}"></script>
						<SCRIPT language="Javascript" src="{$adminjsname}"></SCRIPT>
						<SCRIPT language="Javascript" src="{$adminamjsname}"></SCRIPT>
					</HEAD>
					<BODY style="padding:0;margin-top:0;margin-bottom:0;" bgcolor="#E4E0D8">
						<xsl:variable name="isDetail">
							<xsl:call-template name="isDetailTable">
								<xsl:with-param name="colName" select="//@table_name"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:if test="/EDITOR/@frame_position='filter' and $isDetail='true'">
							<xsl:attribute name="onLoad">javascript:updateEditorButtons();</xsl:attribute>
							<xsl:call-template name="putMaster"/>
							<TABLE class="admininterface" border="0" width="100%">
								<xsl:apply-templates select="EDITOR/MASTER"/>
							</TABLE>
						</xsl:if>
						<xsl:if test="/EDITOR/@frame_position='browser'">
							<xsl:attribute name="onLoad">javascript:updateEditorButtons(); javascript:loadText();</xsl:attribute>
							<FORM name="editor" action="" method="post">
								<xsl:call-template name="putHTMLText"/>
								<xsl:call-template name="htmleditor">
									<xsl:with-param name="bodyonly" select="$bodyonly"/>
								</xsl:call-template>
							</FORM>
						</xsl:if>
					</BODY>
				</HTML>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="putHTMLText">
		<xsl:variable name="txt">
			<xsl:choose>
				<xsl:when test="/EDITOR/ROWSET/ROW[1]/HTML=''">
					<xsl:variable name="htmlsource">
						<xsl:apply-templates select="/EDITOR/ROWSET/ROW[1]/XMLS"/>
					</xsl:variable>
					<xsl:value-of select="xutil:xxml($htmlsource)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="/EDITOR/ROWSET/ROW[1]/HTML"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<input type="hidden" name="htmlsource" value="{$txt}"/>
		<xsl:variable name="amid" select="/EDITOR/ROWSET/ROW[1]/ID"/>
		<input type="hidden" name="amendmentid" value="{$amid}"/>
		<xsl:variable name="amkind" select="/EDITOR/ROWSET/ROW[1]/KIND"/>
		<input type="hidden" name="amendmentkind" value="{$amkind}"/>
	</xsl:template>

	<xsl:template name="htmleditor">
		<xsl:param name="bodyonly"/>
		<xsl:variable name="amkind" select="//XMLS/*/@kind"/>
		<input type="hidden" id="amkind" value="{$amkind}"/>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td>
					<table width="100%" border="0" cellpadding="0" cellspacing="0">
						<tr>
							<td>
								<table bgcolor="#E4E0D8" style="border-collapse: collapse" bordercolor="#111111" cellpadding="1" cellspacing="0" width="100%">
									<tr>
										<td></td>
										<td>
											<table bgcolor="#E4E0D8" style="border-collapse: collapse" bordercolor="#111111" cellpadding="1" cellspacing="0">
												<tr>
													<xsl:call-template name="ed_button">
														<xsl:with-param name="onclick" select="'doIPCLink()'"/>
														<xsl:with-param name="img" select="'ipc.gif'"/>
														<xsl:with-param name="alt" select="'Create link'"/>
													</xsl:call-template>
<!--													
													<td><div id="idDiv_i" style="display:none"><table bgcolor="#E4E0D8" style="border-collapse: collapse" bordercolor="#111111" cellpadding="1" cellspacing="0"><tr>
														<xsl:call-template name="ed_separator"/>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'insertRow(0)'"/>
															<xsl:with-param name="img" select="'insertrowbefore.gif'"/>
															<xsl:with-param name="alt" select="'Insert row before'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'insertRow(1)'"/>
															<xsl:with-param name="img" select="'insertrowafter.gif'"/>
															<xsl:with-param name="alt" select="'Insert row after'"/>
														</xsl:call-template>
													</tr></table></div></td>
-->
													<xsl:call-template name="ed_button">
														<xsl:with-param name="onclick" select="'doInsertFormula()'"/>
														<xsl:with-param name="img" select="'formula.gif'"/>
														<xsl:with-param name="alt" select="'Insert formula'"/>
													</xsl:call-template>
													<xsl:call-template name="ed_button">
														<xsl:with-param name="onclick" select="'doInsertAlpha()'"/>
														<xsl:with-param name="img" select="'alpha.gif'"/>
														<xsl:with-param name="alt" select="'Insert lowercase symbol'"/>
													</xsl:call-template>
													<xsl:call-template name="ed_button">
														<xsl:with-param name="onclick" select="'doInsertOmega()'"/>
														<xsl:with-param name="img" select="'omega.gif'"/>
														<xsl:with-param name="alt" select="'Insert uppercase symbol'"/>
													</xsl:call-template>
													<xsl:call-template name="ed_button">
														<xsl:with-param name="onclick" select="'doInsertBonds()'"/>
														<xsl:with-param name="img" select="'bonds.gif'"/>
														<xsl:with-param name="alt" select="'Insert other symbols'"/>
													</xsl:call-template>
													<td><div id="idDiv_i" style="display:none"><table bgcolor="#E4E0D8" style="border-collapse: collapse" bordercolor="#111111" cellpadding="1" cellspacing="0"><tr>
														<xsl:call-template name="ed_separator"/>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'insertTable()'"/>
															<xsl:with-param name="img" select="'table.gif'"/>
															<xsl:with-param name="alt" select="'Insert table'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'addRow()'"/>
															<xsl:with-param name="img" select="'insertrowbefore.gif'"/>
															<xsl:with-param name="alt" select="'Insert row before'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'addRowAfter()'"/>
															<xsl:with-param name="img" select="'insertrowafter.gif'"/>
															<xsl:with-param name="alt" select="'Insert row after'"/>
														</xsl:call-template>
													</tr></table></div></td>
													<td><div id="idDiv_n" style="display:none"><table bgcolor="#E4E0D8" style="border-collapse: collapse" bordercolor="#111111" cellpadding="1" cellspacing="0"><tr>
														<xsl:call-template name="ed_separator"/>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'doDottedOrder()'"/>
															<xsl:with-param name="img" select="'unorderedlist.gif'"/>
															<xsl:with-param name="alt" select="'Unordered list'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'doNumericOrder(&quot;1&quot;)'"/>
															<xsl:with-param name="img" select="'orderedlist.gif'"/>
															<xsl:with-param name="alt" select="'Ordered list'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'doNumericOrder(&quot;i&quot;)'"/>
															<xsl:with-param name="img" select="'romanlist.gif'"/>
															<xsl:with-param name="alt" select="'Roman list'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'doNumericOrder(&quot;a&quot;)'"/>
															<xsl:with-param name="img" select="'alphalist.gif'"/>
															<xsl:with-param name="alt" select="'Alphabetic list'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_separator"/>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'insertOrphan()'"/>
															<xsl:with-param name="img" select="'orphan.gif'"/>
															<xsl:with-param name="alt" select="'Insert orphan'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'insertCHG(&quot;chg&quot;)'"/>
															<xsl:with-param name="img" select="'chg.gif'"/>
															<xsl:with-param name="alt" select="'Insert edition sign'"/>
														</xsl:call-template>
														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'insertCHG(&quot;new&quot;)'"/>
															<xsl:with-param name="img" select="'new.gif'"/>
															<xsl:with-param name="alt" select="'New sign'"/>
														</xsl:call-template>
<!--														<xsl:call-template name="ed_button">
															<xsl:with-param name="onclick" select="'insertIndex()'"/>
															<xsl:with-param name="img" select="'index.gif'"/>
															<xsl:with-param name="alt" select="'Insert index'"/>
														</xsl:call-template>-->
													</tr></table></div></td>
													
													<td width="100%">
													</td>
												</tr>
											</table>
										</td>
									</tr>
									<tr>
										<td width="25">
											<table bgcolor="#E4E0D8" style="border-collapse: collapse" bordercolor="#111111" cellpadding="1" cellspacing="0">
												<xsl:if test="not($bodyonly!='0')">
													<xsl:call-template name="ed_buttonr">
														<xsl:with-param name="onclick" select="'javascript:mysend();'"/>
														<xsl:with-param name="img" select="'save.gif'"/>
														<xsl:with-param name="alt" select="'Save document'"/>
													</xsl:call-template>
												</xsl:if>
												<xsl:call-template name="ed_buttonr">
													<xsl:with-param name="onclick" select="'doRichEditCommand(&quot;underline&quot;)'"/>
													<xsl:with-param name="img" select="'underline.gif'"/>
													<xsl:with-param name="alt" select="'Underlines'"/>
												</xsl:call-template>
												<xsl:call-template name="ed_buttonr">
													<xsl:with-param name="onclick" select="'doRichEditCommand(&quot;subscript&quot;)'"/>
													<xsl:with-param name="img" select="'subscript.gif'"/>
													<xsl:with-param name="alt" select="'Subscript'"/>
												</xsl:call-template>
												<xsl:call-template name="ed_buttonr">
													<xsl:with-param name="onclick" select="'doRichEditCommand(&quot;superscript&quot;)'"/>
													<xsl:with-param name="img" select="'superscript.gif'"/>
													<xsl:with-param name="alt" select="'Superscript'"/>
												</xsl:call-template>
												<div id="idDiv_d" style="display:none">
													<xsl:call-template name="ed_separatorr"/>
													<xsl:call-template name="ed_buttonr">
														<xsl:with-param name="onclick" select="'doOutdent()'"/>
														<xsl:with-param name="img" select="'outdent.gif'"/>
														<xsl:with-param name="alt" select="'Outdent'"/>
													</xsl:call-template>
													<xsl:call-template name="ed_buttonr">
														<xsl:with-param name="onclick" select="'doIndent()'"/>
														<xsl:with-param name="img" select="'indent.gif'"/>
														<xsl:with-param name="alt" select="'Indent'"/>
													</xsl:call-template>
												</div>
											</table>
										</td>
										<td width="100%" rowspan="10">
											<table border="2">
												<TR>
													<TD>
														<iframe id="editBox" name="editBox" width="100%" height="220px" marginwidth="0" marginheight="0" frameborder="2">
														</iframe>
													</TD>
												</TR>
											</table>

											<input type="button" value="TestButton" name="testbutton" onClick="javascript:copyhtmlsourcefortesing()"/><input type="textfield" name="htmlsourcefortesting"/>
<!--											<input type="button" value="TestButton2" name="testbutton2" onClick="javascript:copyhtmlsourcefortesing2()"/>
-->
											<iframe style="visibility:hidden;" id="sendBox" name="sendBox" width="1px" height="1px" marginwidth="0" marginheight="0" frameborder="0">
											</iframe>
											<br/>
										</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%" border="0">
						<tr>
							<td width="40%" align="right">
								<xsl:call-template name="nbsp"/>
							</td>
							<td width="20%">
								<xsl:call-template name="nbsp"/>
							</td>
							<td width="40%" align="left">
								<xsl:call-template name="nbsp"/>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</xsl:template>

	<msxsl:script language="JScript" implements-prefix="xutil">
	<![CDATA[

	 function xxml(nodelist) {
	      return nodelist.nextNode().xml;
	 }


	]]>
	</msxsl:script>

	<!--/* function print(s)
		{
	      var objFSO;
	      objFSO = new ActiveXObject("Scripting.FileSystemObject");
	      var ts;
	      if( debugCreated ){
	        ts = objFSO.OpenTextFile("c:\\temp\\xutil.log",8);
	      }else{
	        ts = objFSO.CreateTextFile("c:\\temp\\xutil.log",true);
	        debugCreated=1;
	      }
	      ts.Write(s+"\n");
	      ts.Close();
				return "";
	  }
	*/-->

	<xsl:template name="ed_buttonr">
		<xsl:param name="onclick"/>
		<xsl:param name="img"/>
		<xsl:param name="alt"/>
		<tr>
			<td width="25">
				<div class="imagebutton" onClick="{$onclick}" onMouseOver="mouseover(this);" onMouseOut="mouseout(this);">
					<p style="margin-top: 0; margin-bottom: 0"/>
					<img src="{$admineditorgiffolder}images/{$img}" alt="{$alt}" title="{$alt}"/>
				</div>
			</td>
		</tr>
	</xsl:template>

	<xsl:template name="ed_button">
		<xsl:param name="onclick"/>
		<xsl:param name="img"/>
		<xsl:param name="alt"/>
		<td width="25">
			<div class="imagebutton" onClick="{$onclick}" onMouseOver="mouseover(this);" onMouseOut="mouseout(this);">
				<p style="margin-top: 0; margin-bottom: 0"/>
				<img src="{$admineditorgiffolder}images/{$img}" alt="{$alt}" title="{$alt}"/>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="ed_separator">
		<td width="2" valign="middle">
			<img src="{$admineditorgiffolder}images/separator.gif"/>
		</td>
	</xsl:template>

	<xsl:template name="ed_separatorr">
		<tr>
			<td width="2" valign="middle">
				<img src="{$admineditorgiffolder}images/separator2.gif"/>
			</td>
		</tr>
	</xsl:template>

</xsl:stylesheet><!-- Stylus Studio meta-information - (c)1998-2003 Copyright Sonic Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario1" userelativepaths="yes" externalpreview="no" url="file://c:\temp\data.xml" htmlbaseurl="" outputurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
</metaInformation>
-->