<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:msxsl="urn:schemas-microsoft-com:xslt" version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xutil="xutil">
<xsl:output method="html"/>

	<xsl:template name="delAmendment">
		<xsl:param name="bodyonly"/>
		<xsl:choose>
			<xsl:when test="$bodyonly!='1'">
				<HTML>
					<HEAD>
						<TITLE>RIPCIS: Editors</TITLE>
						<LINK rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
						<LINK rel="STYLESHEET" name="styles" type="text/css" href="{$admineditorcssname}"/>
						<script language="javascript" src="{$commonjsname}"></script>
						<script language="javascript" src="{$webservicejsname}"></script>
						<SCRIPT language="Javascript" src="{$adminjsname}"/>
						<SCRIPT language="Javascript" src="{$adminamjsname}"/>
						<SCRIPT language="Javascript" src="{$delamendmentjsname}"/>
					</HEAD>
					<BODY>
						<xsl:variable name="isDetail">
							<xsl:call-template name="isDetailTable">
								<xsl:with-param name="colName" select="//@table_name"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:if test="/EDITOR/@frame_position='filter' and $isDetail='true'">
							<xsl:call-template name="putMaster"/>
							<TABLE class="admininterface" border="0" width="100%">
								<xsl:apply-templates select="EDITOR/MASTER"/>
							</TABLE>
						</xsl:if>
						<xsl:if test="/EDITOR/@frame_position='browser'">
							<FORM name="editor" action="" method="post">
								<xsl:call-template name="delAmendmentBody">
									<xsl:with-param name="bodyonly" select="$bodyonly"/>
								</xsl:call-template>
							</FORM>
						</xsl:if>
					</BODY>
				</HTML>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="delAmendmentBody">
					<xsl:with-param name="bodyonly" select="$bodyonly"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="delAmendmentBody">
		<xsl:param name="bodyonly"/>
		<input type="hidden" id="idGifFolder" value="{$admingiffolder}"/>
		<input type="hidden" id="idAmendId" value="{/EDITOR/ROWSET/ROW[1]/ID}"/>
		<table id="idTable" border="1" cellpadding="1" cellspacing="0" bordercolor="#FFFFFF" bgcolor="#FFFFFF"><tr>
			<td width="50%"><b>transferred to</b></td>
			<td width="50%"><b>covered by</b></td>
		</tr><tr>
			<td width="50%">
			<xsl:call-template name="sheeteditor">
				<xsl:with-param name="filter">transferredTo</xsl:with-param>
			</xsl:call-template>
			</td>
			<td width="50%">
			<xsl:call-template name="sheeteditor">
				<xsl:with-param name="filter">coveredBy</xsl:with-param>
			</xsl:call-template>
			</td>
		</tr>
		<xsl:if test="$bodyonly='0'">
			<tr>
				<td colspan="2" bordercolor="#D4D0C8" bgcolor="#E4E0D8">
					<img src="{$admingiffolder}save.gif" style="cursor: hand;" onclick="delam_submitAll();" alt="Save data to database"/>
				</td>
			</tr>
		</xsl:if>
		</table>
	</xsl:template>

	<xsl:template name="sheeteditor">
		<xsl:param name="filter"/>
		<table border="1" cellpadding="1" cellspacing="0" bordercolor="#D4D0C8" style="border-collapse: collapse" id="idTable_{$filter}">
			<tr bgcolor="#FE9900">
				<td width="23"/>
				<td width="50%">From</td>
				<td width="50%">To</td>
			</tr>
			<xsl:for-each select="//delete/*[name()=$filter]/*">
				<xsl:variable name="color">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 0">
							<xsl:text>#FFFFFF</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>#FFFFFF</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="style">
					<xsl:text>width: 100%; border-left-width: 0px; border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; background-color: </xsl:text>
					<xsl:value-of select="$color"/>
				</xsl:variable>
				<xsl:variable name="rowid">idRow_<xsl:value-of select="$filter"/>_<xsl:value-of select="position()"/></xsl:variable>
				<tr bgcolor="{$color}" id="{$rowid}">
					<td>
						<img src="{$admingiffolder}delete.gif" style="cursor: hand;" onclick="delam_deleteRow('{$filter}', '{$rowid}');" alt="Delete row"/>
					</td>
					<xsl:call-template name="sheetfield">
						<xsl:with-param name="ref" select="@ref"/>
						<xsl:with-param name="style" select="$style"/>
						<xsl:with-param name="id"><xsl:value-of select="$rowid"/>_0</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="sheetfield">
						<xsl:with-param name="ref" select="@endRef"/>
						<xsl:with-param name="style" select="$style"/>
						<xsl:with-param name="id"><xsl:value-of select="$rowid"/>_1</xsl:with-param>
					</xsl:call-template>
				</tr>
			</xsl:for-each>
			<tr>
				<td bgcolor="#FFEFDE" colspan="3">
					<img src="{$admingiffolder}new.gif" style="cursor: hand;" onclick="delam_insertRow('{$filter}');" alt="Add new row"/>
				</td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template name="sheetfield">
		<xsl:param name="ref"/>
		<xsl:param name="style"/>
		<xsl:param name="id"/>
		<td width="50%">
			<input type="text" style="{$style}" id="{$id}" onBlur="delam_onBlur(this);">
				<xsl:attribute name="value">
					<xsl:value-of select="$ref"/>
				</xsl:attribute>
			</input>
		</td>
	</xsl:template>

	<xsl:template match="/">
		<html><head></head>
			<body/>
		</html>
	</xsl:template>

</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2003 Copyright Sonic Software Corporation. All rights reserved.
<metaInformation>
<scenarios ><scenario default="yes" name="Scenario8" userelativepaths="yes" externalpreview="no" url="file://c:\temp\data.xml" htmlbaseurl="" outputurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
</metaInformation>
-->