<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:include href="lang.xsl"/>
    <xsl:template match="sessionDecisions">
        <html>
            <head>
                <TITLE>RIPCIS:  Decisions of <xsl:value-of select="concat(@sessionCode,'/',@sessionNumber)"/></TITLE>
                <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
				<script language="javascript" src="{$commonjsname}"></script>
				<script language="javascript" src="{$webservicejsname}"></script>
                <script language="Javascript" src="{$adminjsname}">
                </script>
            </head>
            <body>
                <table>
                    <tr>
                        <td>
							<h1>Decisions of session <xsl:value-of select="concat(@sessionCode,'/',@sessionNumber)"/></h1>
						</td>
                    </tr>
                </table>
                <xsl:choose>
                    <xsl:when test=".//languageVersions">
                        <xsl:apply-templates select="decisionsByProject/decisionsByArea"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="*/*">
                            <!--					<xsl:sort select="decision/amendment[1]/@orderInProposal" data-type="number"/> -->
                            <xsl:apply-templates/>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="sessionDecisions" mode="inner">
        <table>
            <tr>
                <td>
					<h1>Decisions of session <xsl:value-of select="concat(@sessionCode,'/',@sessionNumber)"/></h1>
				</td>
            </tr>
        </table>
        <xsl:choose>
            <xsl:when test=".//languageVersions">
                <xsl:apply-templates select="decisionsByProject/decisionsByArea"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="*/*">
                    <!--					<xsl:sort select="decision/amendment[1]/@orderInProposal" data-type="number"/> -->
                    <xsl:apply-templates/>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="decisionsByArea">
        <hr class="myhr"/>
        <table width="100%">
            <tr>
                <td width="25%">
					<B><xsl:call-template name="translate"><xsl:with-param name="id">ANNEX</xsl:with-param></xsl:call-template></B>
					<!-- <xsl:value-of select="amendment/@orderInProposal"/> -->
				</td>
                <td width="25%">
					<B>
						<xsl:value-of select="@area"/>
					</B>
					<br/>
					<td width="25%">
						<B>[Project-Rapporteur : <xsl:value-of select="../@projectType"/><xsl:value-of select="ancestor::*/@projectNumber"/>/<xsl:value-of select="../@projectRapporteur"/>]</B>
					</td>
					<td width="25%">
						<B>&lt;<xsl:value-of select=".//amendment/@sessionDecided"/>&gt;<xsl:if test=".//decision/@isTranslation = 'Y'"><br/>
	Translator: <xsl:value-of select=".//decision[@isTranslation='Y']/@projectTranslator"/></xsl:if></B>
					</td>
				</td>
            </tr>
        </table>
        <table width="100%">
            <xsl:apply-templates select="languageVersions/decision/amendment" mode="double"/>
        </table>
    </xsl:template>
    <xsl:template match="proposalsByArea|proposalByArea">
        <hr class="myhr"/>
        <table width="100%">
            <tr>
                <td width="25%">
					<B><xsl:call-template name="translate"><xsl:with-param name="id">ANNEX</xsl:with-param></xsl:call-template></B>
					<!-- <xsl:value-of select="amendment/@orderInProposal"/> -->
				</td>
                <td width="25%">
					<B>
						<xsl:value-of select="@area"/>
					</B>
					<br/>
					<td width="25%">
						<B>[Project-Rapporteur : <xsl:value-of select="../@projectType"/><xsl:value-of select="ancestor::*/@projectNumber"/>/<xsl:value-of select="../@projectRapporteur"/>]</B>
					</td>
					<td width="25%">
						<B>&lt;<xsl:value-of select=".//amendment/@sessionDecided"/>&gt;<xsl:if test=".//proposal/@isTranslation = 'Y'"><br/>
	Translator: <xsl:value-of select=".//decision[@isTranslation='Y']/@projectTranslator"/></xsl:if></B>
					</td>
				</td>
            </tr>
        </table>
        <table width="100%">
<!--            <xsl:apply-templates select="languageVersions/proposal/amendment" mode="double"/>-->
		<xsl:choose>
		<xsl:when test="languageVersions">
			<xsl:apply-templates select="languageVersions/proposal/amendment" mode="double"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="proposal/amendment" />
		</xsl:otherwise>
		</xsl:choose>
        </table>
    </xsl:template>
    <xsl:template match="amendment" mode="double">
        <xsl:variable name="symbol" select="*/@symbol"/>
        <xsl:variable name="endSymbol" select="*/@endSymbol"/>
        <xsl:variable name="kind" select="*/@kind"/>
        <xsl:variable name="sek" select="concat($symbol,';',$endSymbol,';',$kind)"/>
        <xsl:choose>
            <xsl:when test="@lang='EN'">
                <tr style="margin-top:4pt">
                    <xsl:choose>
                        <xsl:when test="*/@entryType='d'">
                            <td width="4%" class="lb">
				            <xsl:call-template name="modifytype"/>
					</td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td width="4%">
				            <xsl:call-template name="modifytype"/>
					</td>
                        </xsl:otherwise>
                    </xsl:choose>
                    <td width="10%">
				<xsl:choose>
					<xsl:when test="new or newunstructured or (modify and @isCType!='N')">
						<i>
							<xsl:call-template name="symbolcell"/>
						</i>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="symbolcell"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
                    <td width="43%">
				<xsl:call-template name="gettext"/>
			</td>
                    <td style="border-left:solid 4pt white" width="43%">
				<xsl:for-each select="../../decision[@lang='FR']/amendment/*[concat(@symbol,';',@endSymbol,';',@kind)=$sek]/..">
					<xsl:call-template name="gettext"/>
				</xsl:for-each>
			</td>
                </tr>
            </xsl:when>
            <xsl:when test="@lang='FR' and ../../decision[@lang='EN']/amendment/*[concat(@symbol,';',@endSymbol,';',@kind)=$sek]">
            </xsl:when>
            <xsl:otherwise>
                <tr style="margin-top:4pt">
                    <xsl:choose>
                        <xsl:when test="*/@entryType='d'">
                            <td width="4%" class="lb">
            <xsl:call-template name="modifytype"/>
					</td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td width="4%">
            <xsl:call-template name="modifytype"/>
					</td>
                        </xsl:otherwise>
                    </xsl:choose>
                    <td width="10%">
				<xsl:choose>
					<xsl:when test="new or newunstructured or (modify and @isCType!='N')">
						<i>
							<xsl:call-template name="symbolcell"/>
						</i>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="symbolcell"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
                    <td width="43%"><xsl:call-template name="nbsp"/></td>
                    <td width="43%">
				<xsl:call-template name="gettext"/>
			</td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
	<xsl:if test="@errorText != ''">
		<tr><td colspan="8" class="error"><xsl:value-of select="@errorText"/></td></tr>
	</xsl:if>
    </xsl:template>
<!--
    <xsl:template match="proposals">
        <html>
            <title>RIPCIS:  <xsl:value-of select="ipcEntry/@symbol"/></title>
            <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
            <script language="Javascript" src="{$adminjsname}">
            </script>
            <body>
                <xsl:choose>
                    <xsl:when test="not(@translationSupport)">
                        <table>
                            <tr>
                                <td>
									<h1>Proposals</h1>
								</td>
                            </tr>
                        </table>
                        <xsl:apply-templates select="proposal"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="topmargin">1</xsl:attribute>
                        <xsl:attribute name="leftmargin">1</xsl:attribute>
                        <xsl:attribute name="rightmargin">1</xsl:attribute>
                        <xsl:attribute name="bottommargin">1</xsl:attribute>
                        <table>
                            <tr>
                                <td>
									<xsl:apply-templates select="//amendment"/>
								</td>
                            </tr>
                        </table>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
-->
    <xsl:template match="decisions">
        <html>
            <title>RIPCIS:  <xsl:value-of select="ipcEntry/@symbol"/></title>
            <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
			<script language="javascript" src="{$commonjsname}"></script>
			<script language="javascript" src="{$webservicejsname}"></script>
            <script language="Javascript" src="{$adminjsname}">
            </script>
            <script language="Javascript" src="{$popupjsname}">
            </script>
            <body onload="javascript:ipcPositionSet();javascript:setResultWindow(); popupReinit()">
                <div id="overDiv" style="z-index: 1000; visibility: hidden; position: absolute; width: 96">
                </div>
                <table>
                    <tr>
                        <td>
							<h1>Decisions</h1>
						</td>
                    </tr>
                </table>
                <xsl:apply-templates select="sessionDecisions" mode="inner"/>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="proposals" mode="skiphtml">
        <table>
            <tr>
                <td>
					<h1>Proposals</h1>
				</td>
            </tr>
        </table>
        <xsl:choose>
            <xsl:when test=".//languageVersions">
                <xsl:apply-templates select="proposalsByProject/proposalsByArea"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="*">
                    <!--					<xsl:sort select="decision/amendment[1]/@orderInProposal" data-type="number"/> -->
                    <xsl:apply-templates />
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="decisions" mode="skiphtml">
        <table>
            <tr>
                <td>
					<h1>Decisions</h1>
				</td>
            </tr>
        </table>
        <xsl:apply-templates select="sessionDecisions" mode="inner"/>
    </xsl:template>
	<xsl:template match="proposalsAndDecisions">
        <html>
            <title>RIPCIS:  <xsl:value-of select="ipcEntry/@symbol"/></title>
            <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
			<script language="javascript" src="{$commonjsname}"></script>
			<script language="javascript" src="{$webservicejsname}"></script>
            <script language="Javascript" src="{$adminjsname}">
            </script>
            <script language="Javascript" src="{$ripcisjsname}">
            </script>
            <script language="Javascript" src="{$popupjsname}">
            </script>
            <body onload="javascript:ipcPositionSet();javascript:setResultWindow(); popupReinit()">
                <div id="overDiv" style="z-index: 1000; visibility: hidden; position: absolute; width: 96">
                </div>
				<xsl:apply-templates mode="skiphtml"/>
			</body>
		</html>
	</xsl:template>
    <xsl:template match="proposals">
        <html>
            <title>RIPCIS:  <xsl:value-of select="ipcEntry/@symbol"/></title>
            <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
			<script language="javascript" src="{$commonjsname}"></script>
			<script language="javascript" src="{$webservicejsname}"></script>
            <script language="Javascript" src="{$adminjsname}">
            </script>
            <script language="Javascript" src="{$popupjsname}">
            </script>
            <body onload="javascript:ipcPositionSet();javascript:setResultWindow(); popupReinit()">
                <div id="overDiv" style="z-index: 1000; visibility: hidden; position: absolute; width: 96">
                </div>
                <table>
                    <tr>
                        <td>
							<h1>Proposals</h1>
						</td>
                    </tr>
                </table>
                <xsl:choose>
                    <xsl:when test=".//languageVersions">
                        <xsl:apply-templates select="proposalsByProject/proposalsByArea"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="*">
                            <!--					<xsl:sort select="decision/amendment[1]/@orderInProposal" data-type="number"/> -->
                            <xsl:apply-templates/>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="proposal">
        <xsl:apply-templates select="sessionDecisions" mode="nothingaround"/>
    </xsl:template>
    <xsl:template match="sessionDecisions" mode="nothingaround">
        <table>
            <tr>
                <td>
					<h1>Decisions on session <xsl:value-of select="concat(@sessionCode,'/',@sessionNumber)"/></h1>
				</td>
            </tr>
        </table>
        <xsl:apply-templates select="*/*/decision"/>
    </xsl:template>
    <xsl:template match="decision">
        <hr class="myhr"/>
        <table width="100%">
            <tr>
                <td width="25%">
					<B><xsl:call-template name="translate"><xsl:with-param name="id">ANNEX</xsl:with-param></xsl:call-template></B>
					<!-- <xsl:value-of select="amendment/@orderInProposal"/> -->
				</td>
                <td width="25%">
					<B>
						<xsl:value-of select="ancestor::*/@area"/>
					</B>
					<br/>
					<td width="25%">
						<B>[Project-Rapporteur : <xsl:value-of select="ancestor::*/@projectType"/><xsl:value-of select="ancestor::*/@projectNumber"/>/<xsl:value-of select="ancestor::*/@projectRapporteur"/>]</B>
					</td>
					<td width="25%">
						<B>&lt;<xsl:value-of select="amendment/@sessionDecided"/>&gt;<xsl:if test="@isTranslation = 'Y'"><br/>
	Translator: <xsl:value-of select="@projectTranslator"/></xsl:if></B>
					</td>
				</td>
            </tr>
        </table>
        <table width="100%" border="0">
            <xsl:apply-templates select="amendment"/>
        </table>
    </xsl:template>
    <xsl:template match="singleamendment">
        <html>
            <head>
                <title>Single amendment</title>
                <link rel="STYLESHEET" name="styles" type="text/css" href="{$admincssname}"/>
            </head>
            <body>
                <xsl:apply-templates select="amendment/*/*" mode="single"/>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="amendment" name="amendment">
	<table width="100%" border="0">
        <xsl:if test="position()!=1">
<!--
            <tr>
                <td colspan="10"><hr size="1"/></td>
            </tr>
-->
        </xsl:if>
        <tr style="margin-top:4pt">
            <xsl:variable name="proj">
				<xsl:value-of select="//proposalsByProject/@projectType"/><xsl:value-of select="//proposalsByProject/@projectNumber"/>
			</xsl:variable>
            <xsl:variable name="area" select="//proposalsByArea/@area"/>
            <td valign="top">
				<xsl:if test="@translationState">
					<img style="cursor:pointer" onclick="editTransAmendments('{$proj}', '{$area}', '{@orderInProposal}', '{@translationState}');">
						<xsl:choose>
							<xsl:when test="@translationState='untranslated'">
								<xsl:attribute name="alt">Untranslated</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$admingiffolder"/>/sign_warn.gif</xsl:attribute>
							</xsl:when>
							<xsl:when test="@translationState='translated'">
								<xsl:attribute name="alt">Translated</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$admingiffolder"/>/sign_ok.gif</xsl:attribute>
							</xsl:when>
							<xsl:when test="@translationState='unknown'">
								<xsl:attribute name="alt">Unknown</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$admingiffolder"/>/sign_stop.gif</xsl:attribute>
							</xsl:when>
							<xsl:when test="@translationState='independent'">
								<xsl:attribute name="alt">Independent</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$admingiffolder"/>/sign_sign.gif</xsl:attribute>
							</xsl:when>
							<xsl:when test="@translationState='unchanged'">
								<xsl:attribute name="alt">Unchanged</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$admingiffolder"/>/sign_quest.gif</xsl:attribute>
							</xsl:when>
						</xsl:choose>
					</img>
				</xsl:if>
			</td>
	    <xsl:if test="1=1"> <!-- to be filled when proposals are presented in 'all' or 'preparatory doc' mode -->
		<td valign="top" width="5%">
			<xsl:value-of select="substring(@amendmentState,3)"/>
		</td>
	    </xsl:if>
            <xsl:choose>
                <xsl:when test="*/@entryType='d'">
                    <td valign="top" width="3%" class="lb">
            			<xsl:call-template name="modifytype"/>
					</td>
                </xsl:when>
                <xsl:otherwise>
                    <td valign="top" width="3%">
            			<xsl:call-template name="modifytype"/>
					</td>
                </xsl:otherwise>
            </xsl:choose>
            <td valign="top" width="5%">
				<xsl:choose>
					<xsl:when test="new or newunstructured or (modify and @isCType!='N')">
						<i>
							<xsl:call-template name="symbolcell"/>
						</i>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="symbolcell"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
            <td valign="top" width="92%">
				<xsl:call-template name="gettext"/>
			</td>
        </tr>
	<xsl:if test="@errorText != ''">
		<tr><td colspan="8" class="error{@errorSeverity}">
			<xsl:choose>
			<xsl:when test="@errorSeverity ='W'">Warning:</xsl:when>
			<xsl:when test="@errorSeverity ='E'">Error:</xsl:when>
			<xsl:otherwise>Information:</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="nbsp"/>
			<xsl:value-of select="@errorText"/></td></tr>
	</xsl:if>
	</table>
    </xsl:template>
    <xsl:template name="compilationModifType">
        <xsl:for-each select="amendment">
            <xsl:call-template name="modifytype"/>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="compilationGetSymbol">
        <xsl:for-each select="amendment">
            <xsl:call-template name="getsymbol"/>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="modifytype">
        <xsl:choose>
            <xsl:when test="new">N</xsl:when>
            <xsl:when test="delete">D</xsl:when>
            <xsl:when test="deleteunstructured">D</xsl:when>
            <xsl:when test="modify and @isCType='N'">M</xsl:when>
            <xsl:when test="unchanged">U</xsl:when>
            <xsl:when test="structure">S</xsl:when>
            <xsl:when test="newunstructured">N</xsl:when>
            <xsl:when test="modifyunstructured and @isCType='N'">M</xsl:when>
            <xsl:when test="modify and @isCType='Y'">C</xsl:when>
            <xsl:when test="modifyunstructured and @isCType='Y'">C</xsl:when>
            <xsl:when test="modifyunstructured">M</xsl:when>
            <xsl:when test="modify and @isCType='N'">M</xsl:when>
            <xsl:when test="renumber">R</xsl:when>
            <xsl:when test="entry-type and @isCType='N'">M</xsl:when>
            <xsl:when test="entry-type and @isCType='Y'">C</xsl:when>
            <xsl:when test="deletenew">D</xsl:when>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="gettext">
        <xsl:choose>
            <xsl:when test="structure">
                <xsl:choose>
                    <xsl:when test="structure/@relativeDotNo &gt;'0'">
                        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Add'"/></xsl:call-template><xsl:value-of select="structure/@relativeDotNo"/><xsl:text> </xsl:text><xsl:call-template name="translate"><xsl:with-param name="id" select="'dot(s)'"/></xsl:call-template>&gt;</TT>
                    </xsl:when>
                    <xsl:otherwise>
                        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Remove'"/></xsl:call-template><xsl:value-of select="-number(structure/@relativeDotNo)"/><xsl:text> </xsl:text><xsl:call-template name="translate"><xsl:with-param name="id" select="'dot(s)'"/></xsl:call-template>&gt;</TT>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="unchanged">
                <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'unchanged'"/></xsl:call-template>&gt;</TT>
            </xsl:when>
            <xsl:when test="core-advanced">
                <xsl:choose>
                    <xsl:when test="core-advanced/@ipcLevel='a'">
                        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'core-to-advanced'"/></xsl:call-template>&gt;</TT>
                    </xsl:when>
                    <xsl:otherwise>
                        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'advanced-to-core'"/></xsl:call-template>&gt;</TT>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="priority">
                <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'standardized sequence'"/></xsl:call-template> <xsl:value-of select="priority/@priorityOrder"/>&gt;</TT>
            </xsl:when>
            <xsl:when test="restore">
                <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'restore to original'"/></xsl:call-template> <xsl:call-template name="purgeSymbol"/> <xsl:if test="*/@endSymbol">-<xsl:call-template name="purgeEndSymbol"/></xsl:if>&gt;</TT>
            </xsl:when>
            <xsl:when test="renumber">
                <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Become(s)'"/></xsl:call-template>
			<xsl:call-template name="purgeSymbolTo"/> <xsl:if test="*/@endToSymbol">-<xsl:call-template name="purgeSymbolEndTo"/></xsl:if><xsl:call-template name="nbsp"/>&gt;</TT>
            </xsl:when>
            <xsl:when test="undelete">
                <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'undelete'"/></xsl:call-template> <xsl:call-template name="purgeSymbol"/> <xsl:if test="*/@endSymbol">-<xsl:call-template name="purgeEndSymbol"/></xsl:if>&gt;</TT>
            </xsl:when>
            <xsl:when test="entry-type">
                <xsl:choose>
                    <xsl:when test="entry-type/@entryType='d'">
                        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Add vertical line'"/></xsl:call-template>&gt;</TT>
                    </xsl:when>
                    <xsl:when test="entry-type/@entryType='c'">
                        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Changed to classification'"/></xsl:call-template>&gt;</TT>
                    </xsl:when>
                    <xsl:when test="entry-type/@entryType='i'">
                        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Changed to indexing'"/></xsl:call-template>&gt;</TT>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="deletenew">
                <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Delete new entry'"/></xsl:call-template>&gt;</TT>
            </xsl:when>
            <xsl:when test="delete">
                <xsl:apply-templates select="delete"/>
            </xsl:when>
	    <xsl:when test="modifyunstructured">
                <xsl:apply-templates select="./*/*"/>
				<xsl:if test="concat(modifyunstructured/@ipcLevel,'') != ''">
					<xsl:choose>
			    <xsl:when test="modifyunstructured/@ipcLevel='a'">
			        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'core-to-advanced'"/></xsl:call-template>&gt;</TT>
			    </xsl:when>
			    <xsl:otherwise>
			        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'advanced-to-core'"/></xsl:call-template>&gt;</TT>
			    </xsl:otherwise>
			</xsl:choose>
					<br/>
				</xsl:if>
				<xsl:if test="concat(modifyunstructured/@toSymbol,'') != ''">
					<TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Become(s)'"/></xsl:call-template> <xsl:call-template name="purgeSymbolTo"/> <xsl:if test="*/@endToSymbol">-<xsl:call-template name="purgeSymbolEndTo"/></xsl:if><xsl:call-template name="nbsp"/>&gt;</TT>
				</xsl:if>
	    </xsl:when>
	    <xsl:when test="moveunstructured">
				<xsl:if test="concat(moveunstructured/@ipcLevel,'') != ''">
					<xsl:choose>
			    <xsl:when test="moveunstructured/@ipcLevel='a'">
			        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'core-to-advanced'"/></xsl:call-template>&gt;</TT>
			    </xsl:when>
			    <xsl:otherwise>
			        <TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'advanced-to-core'"/></xsl:call-template>&gt;</TT>
			    </xsl:otherwise>
			</xsl:choose>
					<br/>
				</xsl:if>
				<xsl:if test="concat(moveunstructured/@toSymbol,'') != ''">
					<TT>&lt;<xsl:call-template name="translate"><xsl:with-param name="id" select="'Become(s)'"/></xsl:call-template> <xsl:call-template name="purgeSymbolTo"/> <xsl:if test="*/@endToSymbol">-<xsl:call-template name="purgeSymbolEndTo"/></xsl:if><xsl:call-template name="nbsp"/>&gt;</TT>
				</xsl:if>
	    </xsl:when>
            <xsl:when test="deleteunstructured">
                <xsl:apply-templates select="deleteunstructured"/>
            </xsl:when>
            <xsl:when test="new or modify">
                <table width="100%" cellpadding="0" cellspacing="0" border="0" >
                    <tr>
                        <xsl:call-template name="dots">
                            <xsl:with-param name="kind" select="./*/@kind"/>
                            <xsl:with-param name="style" select="'d'"/>
                        </xsl:call-template>
                        <td width="100%">
							<xsl:choose>
								<xsl:when test="new or (modify and @isCType='Y')">
									<xsl:choose>
										<xsl:when test="substring-before('#sucm#',*/@kind)">
											<i>
												<b>
													<xsl:apply-templates select="*/*"/>
												</b>
											</i>
										</xsl:when>
										<xsl:otherwise>
											<i>
												<xsl:apply-templates select="./*/*"/>
											</i>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="substring-before('#sucm#',*/@kind)">
											<b>
												<xsl:apply-templates select="*/*"/>
											</b>
										</xsl:when>
										<xsl:otherwise>
											<xsl:apply-templates select="./*/*"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</td>
                    </tr>
                </table>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="./*/*"/>
            </xsl:otherwise>
        </xsl:choose>

        <xsl:if test="@remark">
            <P class="remark">
                <xsl:value-of select="@remark"/>
            </P>
        </xsl:if>

    </xsl:template>
</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2004. Sonic Software Corporation. All rights reserved.
<metaInformation>
<scenarios/><MapperMetaTag><MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/><MapperBlockPosition></MapperBlockPosition></MapperMetaTag>
</metaInformation>
-->
